/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.platform;

import com.openfin.desktop.Identity;
import com.openfin.desktop.JsonBean;
import com.openfin.desktop.platform.AutoResizeOptions;
import com.openfin.desktop.platform.ContextMenuSettings;
import java.awt.Rectangle;
import org.json.JSONObject;

public class PlatformViewOptions
extends JsonBean {
    private AutoResizeOptions autoResizeOptions;
    private ContextMenuSettings contextMenuSettings;
    private Rectangle bounds;
    private Identity target;

    public PlatformViewOptions() {
    }

    public PlatformViewOptions(JSONObject json) {
        super(json);
        this.getBounds();
    }

    public AutoResizeOptions getAutoResizeOptions() {
        if (this.autoResizeOptions == null && this.json.has("AutoResizeOptions")) {
            this.autoResizeOptions = new AutoResizeOptions(this.json.getJSONObject("AutoResizeOptions"));
        }
        return this.autoResizeOptions;
    }

    public void setAutoResizeOptions(AutoResizeOptions options) {
        this.autoResizeOptions = options;
    }

    public ContextMenuSettings getContextMenuSettings() {
        if (this.contextMenuSettings == null && this.json.has("ContextMenuSettings")) {
            this.contextMenuSettings = new ContextMenuSettings(this.json.getJSONObject("ContextMenuSettings"));
        }
        return this.contextMenuSettings;
    }

    public void setContextMenuSettings(ContextMenuSettings contextMenuSettings) {
        this.contextMenuSettings = contextMenuSettings;
    }

    public String getBackgroundColor() {
        return this.getString("backgroundColor");
    }

    public void setBackgroundColor(String backgroundColor) {
        this.setString("backgroundColor", backgroundColor);
    }

    public Rectangle getBounds() {
        if (this.bounds == null && this.json.has("bounds")) {
            JSONObject jsonBounds = this.json.getJSONObject("bounds");
            int x = jsonBounds.has("x") ? jsonBounds.getInt("x") : jsonBounds.getInt("left");
            int y = jsonBounds.has("y") ? jsonBounds.getInt("y") : jsonBounds.getInt("top");
            this.bounds = new Rectangle(x, y, jsonBounds.getInt("width"), jsonBounds.getInt("height"));
        }
        return this.bounds;
    }

    public void setBounds(Rectangle rect) {
        this.bounds = rect;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.setBounds(new Rectangle(x, y, width, height));
    }

    public void setCustomData(Object customData) {
        this.put("customData", customData);
    }

    public Object getCustomContext() {
        return this.json.has("customContext") ? this.json.get("customContext") : null;
    }

    public void setCustomContext(Object customContext) {
        this.put("customContext", customContext);
    }

    public Object getCustomData() {
        return this.json.has("customData") ? this.json.get("customData") : null;
    }

    public String getName() {
        return this.getString("name");
    }

    public void setName(String name) {
        this.setString("name", name);
    }

    public String getUrl() {
        return this.getString("url");
    }

    public void setUrl(String url) {
        this.setString("url", url);
    }

    public String getProcessAffinity() {
        return this.getString("processAffinity");
    }

    public void setProcessAffinity(String processAffinity) {
        this.setString("processAffinity", processAffinity);
    }

    public Identity getTarget() {
        if (this.target == null && this.json.has("target")) {
            this.target = this.getJsonBean("target", Identity.class);
        }
        return this.target;
    }

    @Override
    public JSONObject getJson() {
        if (this.bounds == null) {
            this.json.remove("bounds");
        } else {
            JSONObject jsonViewBounds = new JSONObject();
            jsonViewBounds.put("top", this.bounds.x);
            jsonViewBounds.put("left", this.bounds.y);
            jsonViewBounds.put("width", this.bounds.width);
            jsonViewBounds.put("height", this.bounds.height);
            this.json.put("bounds", (Object)jsonViewBounds);
        }
        this.setJsonBean("target", this.target);
        this.setJsonBean("autoResize", this.autoResizeOptions);
        this.setJsonBean("contextMenuSettings", this.contextMenuSettings);
        return super.getJson();
    }
}

