/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.win32;

import com.openfin.desktop.RuntimeLauncher;
import com.openfin.desktop.win32.RegistryHelper;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.VerRsrc;
import com.sun.jna.platform.win32.Version;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallChecker {
    private static final Logger logger = LoggerFactory.getLogger((String)InstallChecker.class.getName());

    private static String getFileVersion(String path) {
        String version = null;
        if (path != null) {
            try {
                IntByReference dwDummy = new IntByReference();
                dwDummy.setValue(0);
                int versionlength = Version.INSTANCE.GetFileVersionInfoSize(path, dwDummy);
                byte[] bufferarray = new byte[versionlength];
                Memory lpData = new Memory((long)bufferarray.length);
                PointerByReference lplpBuffer = new PointerByReference();
                IntByReference puLen = new IntByReference();
                boolean fileInfoResult = Version.INSTANCE.GetFileVersionInfo(path, 0, versionlength, (Pointer)lpData);
                boolean verQueryVal = Version.INSTANCE.VerQueryValue((Pointer)lpData, "\\", lplpBuffer, puLen);
                VerRsrc.VS_FIXEDFILEINFO lplpBufStructure = new VerRsrc.VS_FIXEDFILEINFO(lplpBuffer.getValue());
                lplpBufStructure.read();
                int v1 = lplpBufStructure.dwFileVersionMS.intValue() >> 16;
                int v2 = lplpBufStructure.dwFileVersionMS.intValue() & 0xFFFF;
                int v3 = lplpBufStructure.dwFileVersionLS.intValue() >> 16;
                int v4 = lplpBufStructure.dwFileVersionLS.intValue() & 0xFFFF;
                version = String.format("%d.%d.%d.%d", v1, v2, v3, v4);
            }
            catch (Exception e) {
                logger.debug(String.format("Error getting file version info %s", path), (Throwable)e);
            }
        }
        return version;
    }

    private static void checkRVM(JSONObject result) {
        String path = RuntimeLauncher.getExistingRVM();
        String version = InstallChecker.getFileVersion(path);
        if (path != null) {
            JSONObject rvm = new JSONObject();
            rvm.put("path", (Object)path);
            rvm.put("version", (Object)version);
            result.put("rvm", (Object)rvm);
        }
    }

    private static void checkRuntime(JSONObject result) {
        String path = RegistryHelper.getRuntimeInstallDirectory();
        if (path != null) {
            JSONArray array = new JSONArray();
            String versionPattern = "^(\\d+\\.)(\\d+\\.)(\\d+\\.)(\\d+)$";
            File dir = new File(path);
            List<File> list = Arrays.asList(dir.listFiles());
            list.forEach(ele -> {
                if (ele.isDirectory() && Pattern.matches(versionPattern, ele.getName())) {
                    JSONObject runtime = new JSONObject();
                    String version = InstallChecker.getRuntimeVersion(ele.getPath());
                    runtime.put("path", (Object)ele.getPath());
                    if (version != null) {
                        runtime.put("version", (Object)version);
                    } else {
                        runtime.put("version", (Object)"not available");
                    }
                    array.put(array.length(), (Object)runtime);
                }
            });
            if (array.length() > 0) {
                result.put("runtime", (Object)array);
            }
        }
    }

    private static String getRuntimeVersion(String path) {
        String exePath = path + File.separator + "OpenFin" + File.separator + "openfin.exe";
        return InstallChecker.getFileVersion(exePath);
    }

    public static JSONObject getInstallInfo() {
        JSONObject result = new JSONObject();
        InstallChecker.checkRVM(result);
        InstallChecker.checkRuntime(result);
        return result;
    }

    public static void main(String[] args) throws IOException {
        System.out.println(InstallChecker.getInstallInfo().toString());
    }
}

