package com.openfin.desktop;

import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Helper object that provides getters/setters for the
 * various options needed for creating an Application.
 */
public class ApplicationOptions extends JsonBean {
    private final static Logger logger = LoggerFactory.getLogger(ApplicationOptions.class.getName());

    WindowOptions mainWindowOptions;

    /**
     * Constructs an instance with the passed options.
     * @param options Options for the application
     */
    public ApplicationOptions(JSONObject options) {
		super(options);
    }

    /**
     * Constructor
     * @param name Name of the application
     * @param uuid UUID of the application
     * @param url  URL of the application
     */
    public ApplicationOptions(String name, String uuid, String url) {
        json = new JSONObject();
        try {
            json.put("name", name);
            json.put("uuid", uuid);
            json.put("url", url);
        } catch (JSONException e) {
            logger.error("Error populating options", e);
        }
    }

    /**
     * Gets name of the application
     * @return Name of the application
     */
    public String getName() {
        return getString("name");
    }

    /**
     * Gets UUID of the application
     * @return UUID of the application
     */
    public String getUUID() {
        return getString("uuid");
    }

    /**
     * Gets URL of the application
     * @return URL of the application
     */
    public String getURL() {
        return getString("url");
    }

    /**
     * Sets options of main window of the application
     * @param options Options of main window
     */
    public void setMainWindowOptions(WindowOptions options) {
        mainWindowOptions = options;
    }

    /**
     * Get options of main window
     * @return Options of main window
     */
    public WindowOptions getMainWindowOptions() {
        return mainWindowOptions;
    }

    /**
     * Sets URL of application icon
     * @param applicationIcon URL
     */
    public void setApplicationIcon(String applicationIcon) {
        try {
            json.put("applicationIcon", applicationIcon);
        } catch (JSONException e) {
            logger.error("Error setting applicationIcon");
        }
    }

    /**
     * Gets URL of application icon
     * @return URL
     */
    public String getApplicationIcon() {
        return getString("applicationIcon");
    }

    /**
     * Sets version of the application
     * @param version Version
     */
    public void setVersion(String version) {
        try {
            json.put("version", version);
        } catch (JSONException e) {
            logger.error("Error setting version");
        }
    }

    /**
     * Gets version of the application
     * @return  Version
     */
    public String getVersion() {
        return getString("version");
    }

    @Override
    public JSONObject getJson() {
    	if (this.mainWindowOptions != null) {
    		this.setJsonBean("mainWindowOptions", this.mainWindowOptions);
    	}
    	return super.getJson();
    }

}
