package com.openfin.desktop;

import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RVMOptions extends JsonBean{
    private final static Logger logger = LoggerFactory.getLogger(RVMOptions.class.getName());

    public RVMOptions(JSONObject options){
        super(options);
    }

    public boolean getNoUI(){
        return getBoolean("noUI");
    }

    public void setNoUI(boolean value){
        try {
            setBoolean("noUI", value);
        }catch(JSONException ex){
            logger.error("Error setting noUI");
        }

    }

    public boolean getDisableAutoUpdates(){
        return getBoolean("disableAutoUpdates");
    }

    public void setDisableAutoUpdates(boolean value){
        setBoolean("disableAutoUpdates", value);
    }

    public boolean getDoNotLaunch(){
        return getBoolean(("doNotLaunch"));
    }

    public void setDoNotLaunch(boolean value){
        setBoolean("doNotLaunch", value);
    }

    public String getInstallDirectory(){
        return getString("installDirectory");
    }

    public void setInstallDirectory(String value){
        setString("installDirectory", value);
    }

    public String getWorkingDirectory(){
        return getString("workingDirectory");
    }

    public void setWorkingDirectory(String value){
        setString("workingDirectory", value);
    }

}
