package com.openfin.desktop.channel;

import java.util.Objects;

import org.json.JSONObject;

public class EndpointIdentity {
	
	private String channelName;
	private String channelId;
	private String uuid;
	private String name;
	private String endpointId;
	private JSONObject json;
	
	public EndpointIdentity(JSONObject json) {
		this.channelName = json.has("channelName") ? json.getString("channelName") : null;
		this.channelId = json.has("channelId") ? json.getString("channelId") : null;
		this.uuid = json.has("uuid") ? json.getString("uuid") : null;
		this.name = (json.has("name") && !json.isNull("name")) ? json.getString("name") : this.uuid;
		this.endpointId = json.has("endpointId") ? json.getString("endpointId") : null;
	}
	
	public EndpointIdentity(String channelName, String channelId, String uuid, String name, String endpointId) {
		this.channelName = channelName;
		this.channelId = channelId;
		this.uuid = uuid;
		this.name = name != null ? name : this.uuid;
		this.endpointId = endpointId != null ? endpointId : null;
	}

	public String getChannelName() {
		return channelName;
	}

	public String getChannelId() {
		return channelId;
	}

	public String getUuid() {
		return uuid;
	}

	public String getName() {
		return name;
	}

	public String getEndpointId() {
		return endpointId;
	}
	
	@Override
	public int hashCode() {
		return Objects.hash(this.channelName, this.channelId, this.uuid, this.name, this.endpointId);
	}
	
	@Override
	public boolean equals(Object obj) {
		boolean b = (this == obj);
		if (!b && obj instanceof EndpointIdentity) {
			EndpointIdentity that = (EndpointIdentity) obj;
			b = (Objects.equals(this.channelName, that.channelName)
					&& Objects.equals(this.channelId, that.channelId)
					&& Objects.equals(this.uuid, that.uuid)
					&& Objects.equals(this.name, that.name)
					&& Objects.equals(this.endpointId, that.endpointId));
		}
		return b;
	}
	
	public JSONObject toJSON() {
		if (this.json == null) {
			this.json = new JSONObject();
			this.json.put("channelName", channelName);
			this.json.put("channelId", channelId);
			this.json.put("uuid", uuid);
			this.json.put("name", name);
			this.json.put("endpointId", endpointId);
		}
		return this.json;
	}
	
	@Override
	public String toString() {
		return toJSON().toString();
	}
}
