package com.openfin.desktop.interop;

import java.util.concurrent.CompletionStage;

import com.openfin.desktop.DesktopConnection;

/**
 * OpenFin Interoperability.
 * @author Anthony
 *
 */
public class Interop {
	private DesktopConnection desktopConnection;

	public Interop(DesktopConnection conn) {
		this.desktopConnection = conn;
	}
	
	/**
	 * Creates a new Interop Client and connects to the Interop Broker.
	 * @param brokerName The name of the Interop Broker that the client will connect to.
	 * @return A new CompletionStage of the Interop Client.
	 */
	public CompletionStage<InteropClient> connect(String brokerName) {
		InteropClientImpl client = new InteropClientImpl(this.desktopConnection, brokerName);
		return client.connect();
	}
}
