package com.openfin.desktop.notifications;

import org.json.JSONObject;

import com.openfin.desktop.Identity;
import com.openfin.desktop.JsonBean;

/**
 * For notifications that have originated from an application running on the same machine as the provider.
 * @author Anthony
 *
 */
public class NotificationSourceDesktop extends JsonBean implements NotificationSource {

	private Identity identity;

	public NotificationSourceDesktop(JSONObject jsonObject) {
		super(jsonObject);
	}

	public Identity getIdentity() {
		if (this.identity == null && this.json.has("identity") && !this.json.isNull("identity")) {
			this.identity = new Identity(this.json.getJSONObject("identity"));
		}
		return this.identity;
	}

	@Override
	public String getType() {
		return this.getString("type");
	}
}
