package com.openfin.desktop.platform;

import org.json.JSONObject;

import com.openfin.desktop.ApplicationOptions;

public class PlatformOptions extends ApplicationOptions {

	public PlatformOptions(String uuid) {
		super(uuid, uuid, null);
		super.put("isPlatformController", true);
	}
	
	public PlatformOptions(JSONObject json) {
		super(json);
	}
	
	public void setDefaultViewOptions(PlatformViewOptions viewOpts) {
		super.put("defaultViewOptions", viewOpts.getJsonCopy());
	}
	
	public void setDefaultWindowOptions(PlatformWindowOptions winOpts) {
		super.put("defaultWindowOptions", winOpts.getJsonCopy());
	}
}
