package com.openfin.desktop.platform;

import java.util.ArrayList;
import java.util.List;

import org.json.JSONObject;

import com.openfin.desktop.JsonBean;
import com.openfin.desktop.WindowOptions;

public class PlatformSnapshot extends JsonBean {

	private List<WindowOptions> windows;
	private PlatformSnapshotDetails snapshotDetails;
	
	public PlatformSnapshot() {
		super();
	}
	
	public PlatformSnapshot(JSONObject json) {
		super(json);
		this.getWindows();
		this.getSnapshotDetails();
	}

	public List<WindowOptions> getWindows() {
		if (this.windows == null && this.json.has("windows")) {
			this.windows = this.getJsonBeanList("windows", WindowOptions.class);
		}
		return this.windows;
	}

	public void setWindows(WindowOptions ... windowOptions) {
		this.windows = new ArrayList<>(windowOptions.length);
		for (WindowOptions winOpt : windowOptions) {
			this.windows.add(winOpt);
		}
	}
	
	public void setWindows(List<WindowOptions> windows) {
		this.windows = windows;
	}
	
	public PlatformSnapshotDetails getSnapshotDetails() {
		if (this.snapshotDetails == null && json.has("snapshotDetails")) {
			this.snapshotDetails = new PlatformSnapshotDetails(json.getJSONObject("snapshotDetails"));
		}
		return this.snapshotDetails;
	}
	
	@Override
	public JSONObject getJson() {
		this.setJsonArray("windows", this.windows);
		this.setJsonBean("snapshotDetails", this.snapshotDetails);
		return super.getJson();
	}
}
