package com.openfin.desktop.platform;

import org.json.JSONObject;

import com.openfin.desktop.JsonBean;
import com.openfin.desktop.MonitorInfo;

public class PlatformSnapshotDetails extends JsonBean {
	
	private MonitorInfo monitorInfo;

	public PlatformSnapshotDetails(JSONObject json) {
		super(json);
		this.getMonitorInfo();
	}
	
	public MonitorInfo getMonitorInfo() {
		if (this.monitorInfo == null && json.has("monitorInfo")) {
			this.monitorInfo = new MonitorInfo(json.getJSONObject("monitorInfo"));
		}
		return this.monitorInfo;
	}
	
	public String getRuntimeInfo() {
		return this.getString("runtimeInfo");
	}
	
	public String getTimeStamp() {
		return this.getString("timeStamp");
	}
}
