/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import com.openfin.desktop.Application;
import com.openfin.desktop.AsyncCallback;
import com.openfin.desktop.DesktopConnection;
import com.openfin.desktop.DesktopException;
import com.openfin.desktop.DesktopUtils;
import com.openfin.desktop.EventListener;
import com.openfin.desktop.Identity;
import com.openfin.desktop.JsonUtils;
import com.openfin.desktop.WebContent;
import com.openfin.desktop.WindowBounds;
import com.openfin.desktop.WindowOptions;
import com.openfin.desktop.animation.AnimationOptions;
import com.openfin.desktop.animation.AnimationTransitions;
import com.openfin.desktop.win32.EmbeddedWindow;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Window
extends WebContent {
    private static Logger logger = LoggerFactory.getLogger((String)Window.class.getName());
    private JSONObject noParamPayload;
    private EmbeddedWindow embeddedWindow;

    private Window(String applicationUuid, String name, DesktopConnection connection) {
        super(new Identity(applicationUuid, name), connection);
        this.initialize();
    }

    protected Window(Application application) {
        super(new Identity(application.getUuid(), application.getUuid()), application.getConnection());
        this.initialize();
    }

    private void initialize() {
        this.noParamPayload = new JSONObject();
        this.noParamPayload.put("uuid", (Object)this.identity.getUuid());
        this.noParamPayload.put("name", (Object)this.identity.getName());
    }

    @Override
    protected String getEventTopicName() {
        return "window";
    }

    public Application getParentApplication() {
        return Application.wrap(this.getUuid(), this.connection);
    }

    public Window getParentWindow() {
        return this.getParentApplication().getWindow();
    }

    public void getSnapshot(AckListener callback) {
        this.connection.sendAction("get-window-snapshot", new JSONObject(), callback, this);
    }

    public void show() throws DesktopException {
        this.connection.sendAction("show-window", this.noParamPayload);
    }

    public void show(AckListener listener) {
        this.connection.sendAction("show-window", this.noParamPayload, listener, this);
    }

    public void hide() throws DesktopException {
        this.connection.sendAction("hide-window", this.noParamPayload);
    }

    public void hide(AckListener listener) {
        this.connection.sendAction("hide-window", this.noParamPayload, listener, this);
    }

    public void close() throws DesktopException {
        this.close(false, null);
    }

    public void close(AckListener listener) {
        this.close(false, listener);
    }

    public void close(Boolean force, AckListener ackListener) {
        this.closeAsync(force).thenAccept(ack -> {
            if (ack.isSuccessful()) {
                DesktopUtils.successAck(ackListener, ack);
            } else {
                DesktopUtils.errorAck(ackListener, ack);
            }
        });
    }

    public CompletableFuture<Ack> closeAsync(Boolean force) {
        JSONObject closePayload = this.identity.getJsonCopy();
        closePayload.put("force", (Object)force);
        return this.connection.sendActionAsync("close-window", closePayload, this);
    }

    public void minimize() throws DesktopException {
        this.connection.sendAction("minimize-window", this.noParamPayload);
    }

    public void minimize(AckListener listener) {
        this.connection.sendAction("minimize-window", this.noParamPayload, listener, this);
    }

    public void maximize() throws DesktopException {
        this.connection.sendAction("maximize-window", this.noParamPayload);
    }

    public void maximize(AckListener listener) {
        this.connection.sendAction("maximize-window", this.noParamPayload, listener, this);
    }

    public void restore() throws DesktopException {
        this.connection.sendAction("restore-window", this.noParamPayload);
    }

    public void restore(AckListener listener) {
        this.connection.sendAction("restore-window", this.noParamPayload, listener, this);
    }

    public void focus() throws DesktopException {
        this.connection.sendAction("focus-window", this.noParamPayload);
    }

    public void focus(AckListener listener) {
        this.connection.sendAction("focus-window", this.noParamPayload, listener, this);
    }

    public void blur() throws DesktopException {
        this.connection.sendAction("blur-window", this.noParamPayload);
    }

    public void blur(AckListener listener) {
        this.connection.sendAction("blur-window", this.noParamPayload, listener, this);
    }

    public void flash(AckListener callback) {
        this.connection.sendAction("flash-window", new JSONObject(), callback, this);
    }

    public void stopFlashing(AckListener callback) {
        this.connection.sendAction("stop-flash-window", new JSONObject(), callback, this);
    }

    public void showAt(int left, int top, boolean toggle) throws DesktopException {
        try {
            JSONObject payload = this.identity.getJsonCopy();
            this.connection.sendAction("show-at-window", payload.put("left", left).put("top", top).put("toggle", toggle));
        }
        catch (JSONException e) {
            throw new DesktopException((Exception)((Object)e));
        }
    }

    public void showAt(int left, int top, boolean toggle, AckListener listener) throws DesktopException {
        try {
            JSONObject payload = this.identity.getJsonCopy();
            this.connection.sendAction("show-at-window", payload.put("left", left).put("top", top).put("toggle", toggle), listener, this);
        }
        catch (JSONException e) {
            throw new DesktopException((Exception)((Object)e));
        }
    }

    public void moveTo(int left, int top) throws DesktopException {
        try {
            JSONObject payload = this.identity.getJsonCopy();
            payload.put("left", left);
            payload.put("top", top);
            this.connection.sendAction("move-window", payload);
        }
        catch (JSONException e) {
            throw new DesktopException((Exception)((Object)e));
        }
    }

    public void moveTo(int left, int top, AckListener listener) throws DesktopException {
        try {
            JSONObject payload = this.identity.getJsonCopy();
            payload.put("left", left);
            payload.put("top", top);
            this.connection.sendAction("move-window", payload, listener, this);
        }
        catch (JSONException e) {
            throw new DesktopException((Exception)((Object)e));
        }
    }

    public void moveBy(int deltaLeft, int deltaTop) throws DesktopException {
        this.moveBy(deltaLeft, deltaTop, null);
    }

    public void moveBy(int deltaLeft, int deltaTop, AckListener listener) throws DesktopException {
        try {
            JSONObject payload = this.identity.getJsonCopy();
            payload.put("deltaLeft", deltaLeft);
            payload.put("deltaTop", deltaTop);
            this.connection.sendAction("move-window-by", payload, listener, this);
        }
        catch (JSONException e) {
            throw new DesktopException((Exception)((Object)e));
        }
    }

    public void resizeTo(int width, int height, String anchor) throws DesktopException {
        try {
            JSONObject payload = this.identity.getJsonCopy();
            payload.put("height", height);
            payload.put("width", width);
            payload.put("anchor", (Object)anchor);
            this.connection.sendAction("resize-window", payload);
        }
        catch (JSONException e) {
            throw new DesktopException((Exception)((Object)e));
        }
    }

    public void resizeTo(int width, int height, String anchor, AckListener listener) throws DesktopException {
        try {
            JSONObject payload = this.identity.getJsonCopy();
            payload.put("height", height);
            payload.put("width", width);
            payload.put("anchor", (Object)anchor);
            this.connection.sendAction("resize-window", payload, listener, this);
        }
        catch (JSONException e) {
            throw new DesktopException((Exception)((Object)e));
        }
    }

    public void resizeTo(int width, int height, AckListener listener) throws DesktopException {
        this.resizeTo(width, height, "top-left", listener);
    }

    public void resizeBy(int deltaWidth, int deltaHeight, String anchor) throws DesktopException {
        try {
            JSONObject payload = this.identity.getJsonCopy();
            payload.put("deltaWidth", deltaWidth);
            payload.put("deltaHeight", deltaHeight);
            payload.put("anchor", (Object)anchor);
            this.connection.sendAction("resize-window-by", payload);
        }
        catch (JSONException e) {
            throw new DesktopException((Exception)((Object)e));
        }
    }

    public void resizeBy(int deltaWidth, int deltaHeight, String anchor, AckListener listener) throws DesktopException {
        try {
            JSONObject payload = this.identity.getJsonCopy();
            payload.put("deltaWidth", deltaWidth);
            payload.put("deltaHeight", deltaHeight);
            payload.put("anchor", (Object)anchor);
            this.connection.sendAction("resize-window-by", payload, listener, this);
        }
        catch (JSONException e) {
            throw new DesktopException((Exception)((Object)e));
        }
    }

    public void getState(AckListener listener) {
        this.connection.sendAction("get-window-state", this.noParamPayload, listener, this);
    }

    public void bringToFront(AckListener listener) {
        this.connection.sendAction("bring-window-to-front", this.noParamPayload, listener, this);
    }

    public void isShowing(AckListener listener) {
        this.connection.sendAction("is-window-showing", this.noParamPayload, listener, this);
    }

    public void getBounds(final AsyncCallback<WindowBounds> callback, final AckListener listener) {
        AckListener mainCallback = null;
        if (callback != null) {
            mainCallback = new AckListener(){

                @Override
                public void onSuccess(Ack ack) {
                    try {
                        JSONObject jsonObject = ack.getJsonObject();
                        JSONObject data = JsonUtils.getJsonValue(jsonObject, "data", null);
                        WindowBounds bounds = new WindowBounds(JsonUtils.getIntegerValue(data, "top", null), JsonUtils.getIntegerValue(data, "left", null), JsonUtils.getIntegerValue(data, "width", null), JsonUtils.getIntegerValue(data, "height", null));
                        callback.onSuccess(bounds);
                    }
                    catch (Exception ex) {
                        logger.error("Error calling onSuccess", (Throwable)ex);
                    }
                }

                @Override
                public void onError(Ack ack) {
                    DesktopUtils.errorAck(listener, ack);
                }
            };
        }
        this.connection.sendAction("get-window-bounds", this.noParamPayload, mainCallback, this);
    }

    public void setBounds(int left, int top, int width, int height, AckListener listener) {
        JSONObject setBoundsPayload = this.identity.getJsonCopy();
        try {
            setBoundsPayload.put("top", top);
            setBoundsPayload.put("left", left);
            setBoundsPayload.put("width", width);
            setBoundsPayload.put("height", height);
            this.connection.sendAction("set-window-bounds", setBoundsPayload, listener, this);
        }
        catch (Exception e) {
            logger.error("Error setting bounds", (Throwable)e);
            DesktopUtils.errorAckOnException(listener, setBoundsPayload, e);
        }
    }

    public void bringToFront() throws DesktopException {
        this.connection.sendAction("bring-window-to-front", this.noParamPayload);
    }

    public void updateOptions(WindowOptions options, AckListener listener) {
        JSONObject payload = this.identity.getJsonCopy();
        try {
            payload.put("options", (Object)options.getJsonCopy());
        }
        catch (JSONException e) {
            DesktopUtils.errorAckOnException(listener, payload, (Exception)((Object)e));
        }
        this.connection.sendAction("update-window-options", payload, listener, this);
    }

    public void getOptions(final AsyncCallback<WindowOptions> callback, AckListener listener) {
        AckListener mainCallback = null;
        if (callback != null) {
            mainCallback = new AckListener(){

                @Override
                public void onSuccess(Ack ack) {
                    try {
                        JSONObject jsonObject = ack.getJsonObject();
                        WindowOptions options = new WindowOptions(JsonUtils.getJsonValue(jsonObject, "data", null));
                        callback.onSuccess(options);
                    }
                    catch (Exception ex) {
                        logger.error("Error calling onSuccess", (Throwable)ex);
                    }
                }

                @Override
                public void onError(Ack ack) {
                }
            };
        }
        this.connection.sendAction("get-window-options", this.noParamPayload, mainCallback, this);
    }

    public void setAsForeground(AckListener listener) {
        this.connection.sendAction("set-foreground-window", this.noParamPayload, listener, this);
    }

    public void enableFrame(AckListener listener) {
        this.connection.sendAction("enable-window-frame", this.noParamPayload, listener, this);
    }

    public void disableFrame(AckListener listener) {
        this.connection.sendAction("disable-window-frame", this.noParamPayload, listener, this);
    }

    public void updateOptions(JSONObject options) throws DesktopException {
        JSONObject payload = this.identity.getJsonCopy();
        try {
            payload.put("options", (Object)options);
        }
        catch (JSONException e) {
            throw new DesktopException((Exception)((Object)e));
        }
        this.connection.sendAction("update-window-options", payload);
    }

    public void getNativeId(AckListener listener) {
        this.connection.sendAction("get-window-native-id", this.identity.getJson(), listener, this);
    }

    public static Window wrap(String applicationUuid, String windowName, DesktopConnection connection) {
        return new Window(applicationUuid, windowName, connection);
    }

    public void joinGroup(Window window) throws DesktopException {
        JSONObject payload = this.identity.getJsonCopy();
        try {
            payload.put("groupingUuid", (Object)window.getUuid());
            payload.put("groupingWindowName", (Object)window.getName());
        }
        catch (JSONException e) {
            throw new DesktopException((Exception)((Object)e));
        }
        this.connection.sendAction("join-window-group", payload);
    }

    public void joinGroup(Window window, AckListener listener) {
        JSONObject payload = this.identity.getJsonCopy();
        try {
            payload.put("groupingUuid", (Object)window.getUuid());
            payload.put("groupingWindowName", (Object)window.getName());
        }
        catch (JSONException e) {
            logger.error("Error joining group", (Throwable)e);
        }
        this.connection.sendAction("join-window-group", payload, listener, this);
    }

    public void mergeGroups(Window window) throws DesktopException {
        JSONObject payload = this.identity.getJsonCopy();
        try {
            payload.put("groupingUuid", (Object)window.getUuid());
            payload.put("groupingWindowName", (Object)window.getName());
        }
        catch (JSONException e) {
            throw new DesktopException((Exception)((Object)e));
        }
        this.connection.sendAction("merge-window-groups", payload);
    }

    public void mergeGroups(Window window, AckListener listener) {
        JSONObject payload = this.identity.getJsonCopy();
        try {
            payload.put("groupingUuid", (Object)window.getUuid());
            payload.put("groupingWindowName", (Object)window.getName());
        }
        catch (JSONException e) {
            DesktopUtils.errorAckOnException(listener, payload, (Exception)((Object)e));
        }
        this.connection.sendAction("merge-window-groups", payload, listener, this);
    }

    public void leaveGroup() throws DesktopException {
        this.connection.sendAction("leave-window-group", this.identity.getJson());
    }

    public void leaveGroup(AckListener listener) {
        this.connection.sendAction("leave-window-group", this.identity.getJson(), listener, this);
    }

    public void animate(AnimationTransitions transitions, AnimationOptions options, AckListener listener) {
        JSONObject animationPayload = this.identity.getJsonCopy();
        try {
            if (transitions != null) {
                animationPayload.put("transitions", (Object)transitions.toJsonObject());
            }
            if (options != null) {
                animationPayload.put("options", (Object)options.getOptions());
            }
            this.connection.sendAction("animate-window", animationPayload, listener, this);
        }
        catch (Exception e) {
            logger.error("Error animating", (Throwable)e);
        }
    }

    public void getGroup(final AsyncCallback<List<Window>> groupHandler, final AckListener listener) {
        if (groupHandler != null) {
            JSONObject payload = this.identity.getJsonCopy();
            payload.put("crossApp", true);
            this.connection.sendAction("get-window-group", payload, new AckListener(){

                @Override
                public void onSuccess(Ack ack) {
                    ArrayList<Window> list = new ArrayList<Window>();
                    try {
                        JSONObject value = ack.getJsonObject();
                        if (value != null) {
                            JSONArray array = value.getJSONArray("data");
                            for (int i = 0; i < array.length(); ++i) {
                                JSONObject item = array.getJSONObject(i);
                                list.add(Window.wrap(item.getString("uuid"), item.getString("windowName"), Window.this.connection));
                            }
                        }
                        groupHandler.onSuccess(list);
                    }
                    catch (Exception e) {
                        logger.error("Error processing group", (Throwable)e);
                    }
                }

                @Override
                public void onError(Ack ack) {
                    DesktopUtils.errorAck(listener, ack);
                }
            }, this);
        }
    }

    public void addEventListener(String type, EventListener listener, AckListener callback) {
        super.addEventListener(type, listener).thenAccept(ack -> {
            if (ack.isSuccessful()) {
                DesktopUtils.successAck(callback, ack);
            } else {
                DesktopUtils.errorAck(callback, ack);
            }
        });
    }

    public void removeEventListener(String type, EventListener listener, AckListener callback) {
        try {
            JSONObject eventListenerPayload = this.identity.getJsonCopy();
            eventListenerPayload.put("topic", (Object)"window");
            eventListenerPayload.put("type", (Object)type);
            this.connection.removeEventCallback(eventListenerPayload, listener, callback, this);
        }
        catch (Exception e) {
            logger.error("Error removing event listener", (Throwable)e);
        }
    }

    public void embedInto(long parentHwndId, int width, int height, AckListener callback) {
        this.embedInto(parentHwndId, 0, 0, width, height, callback);
    }

    public synchronized void embedInto(long parentHwndId, int left, int top, int width, int height, AckListener callback) {
        WindowBounds bounds = new WindowBounds(top, left, width, height);
        if (this.embeddedWindow == null) {
            this.embeddedWindow = new EmbeddedWindow(this);
        }
        this.embeddedWindow.embed(parentHwndId, bounds, callback);
    }

    public void executeJavaScript(String code, final AsyncCallback<Object> callback, final AckListener listener) {
        AckListener mainCallback = null;
        if (callback != null) {
            mainCallback = new AckListener(){

                @Override
                public void onSuccess(Ack ack) {
                    try {
                        JSONObject jsonObject = ack.getJsonObject();
                        if (jsonObject.has("data")) {
                            Object data = jsonObject.get("data");
                            if (data == JSONObject.NULL) {
                                callback.onSuccess(null);
                            } else {
                                callback.onSuccess(data);
                            }
                        } else {
                            JSONObject payload = new JSONObject();
                            JsonUtils.updateValue(payload, "reason", "Missing data in response");
                            Ack ack2 = new Ack(payload, this);
                            DesktopUtils.errorAck(listener, ack2);
                        }
                    }
                    catch (Exception ex) {
                        logger.error("Error calling onSuccess", (Throwable)ex);
                    }
                }

                @Override
                public void onError(Ack ack) {
                    DesktopUtils.errorAck(listener, ack);
                }
            };
        }
        JSONObject payload = this.identity.getJsonCopy();
        try {
            payload.put("code", (Object)code);
            this.connection.sendAction("execute-javascript-in-window", payload, mainCallback, this);
        }
        catch (Exception e) {
            logger.error("Error executing javascript", (Throwable)e);
            DesktopUtils.errorAckOnException(listener, this, e);
        }
    }

    public void showDeveloperTools(AckListener listener) {
        try {
            this.connection.sendAction("show-developer-tools", this.identity.getJson(), listener, this);
        }
        catch (Exception e) {
            logger.error("Error showing devtools", (Throwable)e);
            DesktopUtils.errorAckOnException(listener, this, e);
        }
    }

    public void navigate(String url, AckListener listener) {
        JSONObject payload = new JSONObject();
        try {
            payload.put("targetUuid", (Object)this.getUuid());
            payload.put("targetName", (Object)this.getName());
            payload.put("url", (Object)url);
            this.connection.sendAction("redirect-window-to-url", payload, listener, this);
        }
        catch (Exception e) {
            logger.error("Error navigating", (Throwable)e);
            DesktopUtils.errorAckOnException(listener, this, e);
        }
    }

    public void navigateForward(AckListener listener) {
        try {
            this.connection.sendAction("navigate-window-forward", this.identity.getJson(), listener, this);
        }
        catch (Exception e) {
            logger.error("Error navigating", (Throwable)e);
            DesktopUtils.errorAckOnException(listener, this, e);
        }
    }

    public void navigateBack(AckListener listener) {
        try {
            this.connection.sendAction("navigate-window-back", this.identity.getJson(), listener, this);
        }
        catch (Exception e) {
            logger.error("Error navigating", (Throwable)e);
            DesktopUtils.errorAckOnException(listener, this, e);
        }
    }

    public void stopWindowNavigation(AckListener listener) {
        try {
            this.connection.sendAction("stop-window-navigation", this.identity.getJson(), listener, this);
        }
        catch (Exception e) {
            logger.error("Error navigating", (Throwable)e);
            DesktopUtils.errorAckOnException(listener, this, e);
        }
    }

    public void authenticate(String username, String password, boolean cancel, AckListener listener) {
        JSONObject payload = this.identity.getJsonCopy();
        try {
            payload.put("userName", (Object)username);
            payload.put("password", (Object)password);
            payload.put("cancel", cancel);
            this.connection.sendAction("window-authenticate", payload, listener, this);
        }
        catch (Exception e) {
            logger.error("Error navigating", (Throwable)e);
            DesktopUtils.errorAckOnException(listener, this, e);
        }
    }

    public void getInfo(String code, final AsyncCallback<JSONObject> callback, final AckListener listener) {
        AckListener mainCallback = null;
        if (callback != null) {
            mainCallback = new AckListener(){

                @Override
                public void onSuccess(Ack ack) {
                    try {
                        JSONObject jsonObject = ack.getJsonObject();
                        if (jsonObject.has("data")) {
                            JSONObject data = jsonObject.getJSONObject("data");
                            callback.onSuccess(data);
                        } else {
                            JSONObject payload = new JSONObject();
                            JsonUtils.updateValue(payload, "reason", "Missing data in response");
                            Ack ack2 = new Ack(payload, this);
                            DesktopUtils.errorAck(listener, ack2);
                        }
                    }
                    catch (Exception ex) {
                        logger.error("Error calling onSuccess", (Throwable)ex);
                    }
                }

                @Override
                public void onError(Ack ack) {
                    DesktopUtils.errorAck(listener, ack);
                }
            };
        }
        try {
            this.connection.sendAction("get-window-info", null, listener, this);
        }
        catch (Exception e) {
            logger.error("Error executing javascript", (Throwable)e);
            DesktopUtils.errorAckOnException(listener, this, e);
        }
    }

    public void embedComponentSizeChange(int width, int height) {
        this.embedComponentSizeChange(0, 0, width, height);
    }

    public void embedComponentSizeChange(int left, int top, int width, int height) {
        if (this.embeddedWindow != null) {
            this.embeddedWindow.embedComponentSizeChange(left, top, width, height);
        }
    }

    public void getZoomLevel(final AsyncCallback<Double> callback, final AckListener listener) {
        AckListener mainCallback = null;
        if (callback != null) {
            mainCallback = new AckListener(){

                @Override
                public void onSuccess(Ack ack) {
                    try {
                        Double level = Double.parseDouble(ack.getData().toString());
                        callback.onSuccess(level);
                    }
                    catch (Exception ex) {
                        logger.error("Error calling onSuccess", (Throwable)ex);
                    }
                }

                @Override
                public void onError(Ack ack) {
                    DesktopUtils.errorAck(listener, ack);
                }
            };
        }
        this.connection.sendAction("get-zoom-level", this.noParamPayload, mainCallback, this);
    }

    public void setZoomLevel(double level, AckListener listener) {
        JSONObject payload = this.identity.getJsonCopy();
        try {
            payload.put("level", level);
            this.connection.sendAction("set-zoom-level", payload, listener, this);
        }
        catch (Exception e) {
            logger.error("Error setting zoom level", (Throwable)e);
            DesktopUtils.errorAckOnException(listener, payload, e);
        }
    }

    public void reload(boolean ignoreCache, AckListener listener) {
        JSONObject payload = this.identity.getJsonCopy();
        payload.put("ignoreCache", ignoreCache);
        this.connection.sendAction("reload-window", payload, listener, this);
    }
}

