/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.channel;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import com.openfin.desktop.AsyncCallback;
import com.openfin.desktop.DesktopConnection;
import com.openfin.desktop.channel.ChannelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractServiceClient {
    protected Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    protected String channelName;
    protected ChannelClient channelClient;
    protected DesktopConnection desktopConnection;

    protected AbstractServiceClient(String channelName, DesktopConnection desktopConnection) {
        this.channelName = channelName;
        this.desktopConnection = desktopConnection;
    }

    protected void setChannelName(String name) {
        this.channelName = name;
        this.logger.debug(String.format("Setting FDC3 provider channel name %s", name));
    }

    public void connect(final AckListener ackListener) {
        this.desktopConnection.getChannel(this.channelName).connect(new AsyncCallback<ChannelClient>(){

            @Override
            public void onSuccess(ChannelClient client) {
                AbstractServiceClient.this.channelClient = client;
                AbstractServiceClient.this.onChannelConnected();
                Ack ack = new Ack(null, AbstractServiceClient.this);
                AbstractServiceClient.this.logger.debug(String.format("Connected to service %s", AbstractServiceClient.this.channelName));
                ackListener.onSuccess(ack);
            }
        });
    }

    protected void onChannelConnected() {
        this.logger.debug(String.format("Connected to channel %s", this.channelName));
    }
}

