/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.channel;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import com.openfin.desktop.ActionEvent;
import com.openfin.desktop.AsyncCallback;
import com.openfin.desktop.DesktopConnection;
import com.openfin.desktop.DesktopException;
import com.openfin.desktop.EventListener;
import com.openfin.desktop.channel.ChannelBase;
import com.openfin.desktop.channel.ChannelClient;
import com.openfin.desktop.channel.ChannelListener;
import com.openfin.desktop.channel.ChannelProvider;
import com.openfin.desktop.channel.ConnectionEvent;
import com.openfin.desktop.channel.EndpointIdentity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Channel {
    private static final Logger logger = LoggerFactory.getLogger((String)Channel.class.getName());
    private final DesktopConnection desktopConnection;
    private final String name;
    private ChannelProvider provider;
    private final ConcurrentHashMap<String, ChannelClient> clientMap;
    private final CopyOnWriteArrayList<ChannelListener> channelListeners;
    private final CopyOnWriteArrayList<CompletableFuture<ChannelClient>> pendingConnections;
    private static final String CONNECTED_EVENT = "connected";
    private static final String DISCONNECTED_EVENT = "disconnected";
    private static final String PROVIDER_NOT_READY_REASON = "internal-nack";

    public Channel(String name, DesktopConnection desktopConnection) {
        this.name = name;
        this.desktopConnection = desktopConnection;
        this.clientMap = new ConcurrentHashMap();
        this.channelListeners = new CopyOnWriteArrayList();
        this.pendingConnections = new CopyOnWriteArrayList();
        try {
            this.addEventListener(CONNECTED_EVENT, (ActionEvent e) -> {
                String eventChannelName = e.getEventObject().getString("channelName");
                if (eventChannelName.equals(this.name)) {
                    logger.debug("channel[{}] connected", (Object)this.name);
                    JSONObject providerIdentity = e.getEventObject();
                    EndpointIdentity ei = new EndpointIdentity(providerIdentity);
                    this.fireChannelConnectEvent(new ConnectionEvent(ei.getChannelId(), ei.getUuid(), ei.getName(), ei.getChannelName(), ei.getEndpointId()));
                    ArrayList<CompletableFuture<ChannelClient>> connectionFutures = new ArrayList<CompletableFuture<ChannelClient>>(this.pendingConnections);
                    this.pendingConnections.clear();
                    connectionFutures.forEach((Consumer<CompletableFuture<ChannelClient>>)((Consumer<CompletableFuture>)connectionFuture -> this.connectAsync().thenAccept(client -> connectionFuture.complete(client))));
                }
            }, null);
            this.addEventListener(DISCONNECTED_EVENT, (ActionEvent e) -> {
                String eventChannelName = e.getEventObject().getString("channelName");
                if (eventChannelName.equals(this.name)) {
                    logger.debug("channel[{}] disconnected", (Object)this.name);
                    JSONObject providerIdentity = e.getEventObject();
                    EndpointIdentity ei = new EndpointIdentity(providerIdentity);
                    this.fireChannelDisconnectEvent(new ConnectionEvent(ei.getChannelId(), ei.getUuid(), ei.getName(), ei.getChannelName(), ei.getEndpointId()));
                }
            }, null);
        }
        catch (DesktopException e2) {
            logger.error("unable to subscribe to channel events", (Throwable)e2);
        }
    }

    public String getName() {
        return this.name;
    }

    public DesktopConnection getDesktopConnection() {
        return this.desktopConnection;
    }

    public CompletionStage<ChannelProvider> createAsync() {
        JSONObject payload = new JSONObject();
        payload.put("channelName", (Object)this.name);
        return this.desktopConnection.sendActionAsync("create-channel", payload, this).thenApply(ack -> {
            if (ack.isSuccessful()) {
                JSONObject providerIdentity = (JSONObject)ack.getData();
                EndpointIdentity providerEndpointIdentity = new EndpointIdentity(providerIdentity);
                this.provider = new ChannelProvider(this, providerEndpointIdentity);
                return this.provider;
            }
            throw new RuntimeException("error creating channel provider, reason: " + ack.getReason());
        });
    }

    public void create(AsyncCallback<ChannelProvider> callback) {
        this.createAsync().thenAccept(provider -> callback.onSuccess((ChannelProvider)provider));
    }

    void destroy(ChannelBase provider, final AckListener ackListener) {
        JSONObject payload = new JSONObject();
        payload.put("channelName", (Object)provider.getChannelName());
        this.desktopConnection.sendAction("destroy-channel", payload, new AckListener(){

            @Override
            public void onSuccess(Ack ack) {
                Channel.this.provider = null;
                if (ackListener != null) {
                    ackListener.onSuccess(ack);
                }
            }

            @Override
            public void onError(Ack ack) {
                if (ackListener != null) {
                    ackListener.onError(ack);
                }
            }
        }, this);
    }

    public CompletionStage<ChannelClient> connectAsync() {
        return this.connectAsync(null, null);
    }

    public CompletionStage<ChannelClient> connectAsync(Object connectPayload) {
        return this.connectAsync(null, connectPayload);
    }

    public CompletionStage<ChannelClient> connectAsync(Boolean noWait, Object connectPayload) {
        JSONObject payload = new JSONObject();
        payload.put("channelName", (Object)this.name);
        if (connectPayload != null) {
            payload.put("payload", connectPayload);
        }
        CompletableFuture<ChannelClient> connectionFuture = new CompletableFuture<ChannelClient>();
        this.desktopConnection.sendActionAsync("connect-to-channel", payload, this).thenAccept(ack -> {
            if (ack.isSuccessful()) {
                JSONObject providerIdentity = (JSONObject)ack.getData();
                EndpointIdentity endpointIdentity = new EndpointIdentity(providerIdentity);
                ChannelClient client = new ChannelClient(this, endpointIdentity);
                this.clientMap.put(endpointIdentity.getEndpointId(), client);
                connectionFuture.complete(client);
            } else if (!PROVIDER_NOT_READY_REASON.equals(ack.getReason())) {
                connectionFuture.completeExceptionally(new RuntimeException("error connecting to channel " + this.name + ", reason: " + ack.getReason()));
            } else if (noWait != null && noWait.booleanValue()) {
                connectionFuture.completeExceptionally(new RuntimeException("error connecting to channel " + this.name + ", reason: " + ack.getReason()));
            } else {
                this.pendingConnections.add(connectionFuture);
            }
        });
        return connectionFuture;
    }

    public void connect(AsyncCallback<ChannelClient> callback) {
        this.connectAsync().thenAccept(client -> callback.onSuccess((ChannelClient)client));
    }

    void disconnect(ChannelBase client, final AckListener ackListener) {
        JSONObject payload = new JSONObject();
        payload.put("channelName", (Object)client.getChannelName());
        this.desktopConnection.sendAction("disconnect-from-channel", payload, new AckListener(){

            @Override
            public void onSuccess(Ack ack) {
                if (ackListener != null) {
                    ackListener.onSuccess(ack);
                }
            }

            @Override
            public void onError(Ack ack) {
                ackListener.onError(ack);
            }
        }, this);
    }

    void sendChannelMessage(String action, JSONObject destionationIdentity, JSONObject providerIdentity, JSONObject actionPayload, AckListener ackListener) {
        JSONObject payload = new JSONObject(destionationIdentity, new String[]{"name", "uuid", "channelId", "channelName", "endpointId"});
        payload.put("providerIdentity", (Object)providerIdentity);
        payload.put("action", (Object)action);
        payload.put("payload", (Object)actionPayload);
        this.desktopConnection.sendAction("send-channel-message", payload, ackListener, this);
    }

    CompletableFuture<Ack> sendChannelMessageAsync(String action, JSONObject destionationIdentity, JSONObject providerIdentity, Object actionPayload) {
        JSONObject payload = new JSONObject(destionationIdentity, new String[]{"name", "uuid", "channelId", "channelName", "endpointId"});
        payload.put("providerIdentity", (Object)providerIdentity);
        payload.put("action", (Object)action);
        payload.put("payload", actionPayload);
        return this.desktopConnection.sendActionAsync("send-channel-message", payload, this);
    }

    public boolean hasProvider() {
        return this.provider != null;
    }

    public boolean hasClient() {
        return ((ConcurrentHashMap.CollectionView)((Object)this.clientMap.keySet())).size() > 0;
    }

    public Object invokeAction(EndpointIdentity targetIdentity, String action, Object actionPayload, JSONObject senderIdentity) {
        Object target = null;
        Object result = null;
        if (targetIdentity.getEndpointId() != null) {
            ChannelClient channelClient = this.clientMap.get(targetIdentity.getEndpointId());
            if (channelClient != null && channelClient.hasRegisteredAction(action)) {
                result = channelClient.invokeAction(action, actionPayload, senderIdentity);
            }
        } else if (this.provider != null && this.provider.hasRegisteredAction(action)) {
            result = this.provider.invokeAction(action, actionPayload, senderIdentity);
        } else {
            Collection<ChannelClient> clients = this.clientMap.values();
            JSONArray results = new JSONArray();
            for (ChannelClient client : clients) {
                Object cr;
                if (!client.hasRegisteredAction(action) || (cr = client.invokeAction(action, actionPayload, senderIdentity)) == null) continue;
                results.put(cr);
            }
            result = results.length() == 1 ? results.get(0) : results;
        }
        return result;
    }

    public boolean addChannelListener(ChannelListener listener) {
        return this.channelListeners.add(listener);
    }

    public boolean removeChannelListener(ChannelListener listener) {
        return this.channelListeners.remove(listener);
    }

    protected void fireChannelConnectEvent(ConnectionEvent event) {
        for (ChannelListener listener : this.channelListeners) {
            listener.onChannelConnect(event);
        }
        this.clientMap.values().forEach(channelClient -> channelClient.fireChannelConnectEvent(event));
    }

    protected void fireChannelDisconnectEvent(ConnectionEvent event) {
        for (ChannelListener listener : this.channelListeners) {
            listener.onChannelDisconnect(event);
        }
        this.clientMap.values().forEach(channelClient -> channelClient.fireChannelDisconnectEvent(event));
    }

    public void processConnection(JSONObject payload) throws Exception {
        JSONObject clientIdentity = payload.getJSONObject("clientIdentity");
        this.provider.processConnection(clientIdentity, payload);
    }

    protected void addEventListener(JSONObject subscriptionObject, EventListener listener, AckListener callback) throws DesktopException {
        this.desktopConnection.addEventCallback(subscriptionObject, listener, callback, this);
    }

    public void addEventListener(String type, EventListener listener, AckListener callback) throws DesktopException {
        try {
            JSONObject eventListenerPayload = new JSONObject();
            eventListenerPayload.put("topic", (Object)"channel");
            eventListenerPayload.put("type", (Object)type);
            this.addEventListener(eventListenerPayload, listener, callback);
        }
        catch (Exception e) {
            logger.error("Error adding event listener", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public void removeEventListener(String type, EventListener listener, AckListener callback) throws DesktopException {
        try {
            JSONObject eventListenerPayload = new JSONObject();
            eventListenerPayload.put("topic", (Object)"channel");
            eventListenerPayload.put("type", (Object)type);
            this.desktopConnection.removeEventCallback(eventListenerPayload, listener, callback, this);
        }
        catch (Exception e) {
            logger.error("Error removing event listener", (Throwable)e);
            throw new DesktopException(e);
        }
    }
}

