/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.channel;

import com.openfin.desktop.AckListener;
import com.openfin.desktop.ActionEvent;
import com.openfin.desktop.EventListener;
import com.openfin.desktop.channel.Channel;
import com.openfin.desktop.channel.ChannelAction;
import com.openfin.desktop.channel.ChannelBase;
import com.openfin.desktop.channel.ChannelClientConnectEvent;
import com.openfin.desktop.channel.ChannelListener;
import com.openfin.desktop.channel.ChannelProviderListener;
import com.openfin.desktop.channel.ConnectionEvent;
import com.openfin.desktop.channel.EndpointIdentity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelProvider
extends ChannelBase {
    private static final Logger logger = LoggerFactory.getLogger((String)ChannelProvider.class.getName());
    private final ArrayList<EndpointIdentity> clients = new ArrayList();
    private final CopyOnWriteArrayList<ChannelProviderListener> providerListeners = new CopyOnWriteArrayList();
    private static final String CLIENT_DISCONNECTED_EVENT = "client-disconnected";

    ChannelProvider(Channel messageChannelFactory, final EndpointIdentity endpointIdentity) {
        super(messageChannelFactory, endpointIdentity);
        this.channel.addChannelListener(new ChannelListener(){

            @Override
            public void onChannelConnect(ConnectionEvent connectionEvent) {
            }

            @Override
            public void onChannelDisconnect(ConnectionEvent connectionEvent) {
                ChannelProvider.this.processDisconnection(connectionEvent.getUuid(), connectionEvent.getName());
            }
        });
        JSONObject eventListenerPayload = new JSONObject();
        eventListenerPayload.put("topic", (Object)"channel");
        eventListenerPayload.put("type", (Object)CLIENT_DISCONNECTED_EVENT);
        this.channel.getDesktopConnection().addEventCallback(eventListenerPayload, new EventListener(){

            @Override
            public void eventReceived(ActionEvent actionEvent) {
                JSONObject event = actionEvent.getEventObject();
                if (ChannelProvider.this.channel.getName().equals(event.getString("channelName"))) {
                    String uuid = event.getString("uuid");
                    String name = event.getString("name");
                    ChannelProvider.this.processDisconnection(uuid, name);
                    ChannelProvider.this.channel.fireChannelDisconnectEvent(new ConnectionEvent(endpointIdentity.getChannelId(), uuid, name, endpointIdentity.getChannelName(), endpointIdentity.getEndpointId()));
                }
            }
        }, null, this);
    }

    public void destroy(AckListener ackListener) {
        this.channel.destroy(this, ackListener);
    }

    public void processConnection(JSONObject clientIdentity, JSONObject connectionPayload) throws Exception {
        String clientUuid = clientIdentity.has("uuid") ? clientIdentity.getString("uuid") : null;
        String clientName = clientIdentity.has("name") ? clientIdentity.getString("name") : null;
        String clientEndpointId = clientIdentity.has("endpointId") ? clientIdentity.getString("endpointId") : null;
        EndpointIdentity clientEndpointIdentity = new EndpointIdentity(this.getChannelName(), this.getChannelId(), clientUuid, clientName, clientEndpointId);
        this.fireClientConnectEvent(new ChannelClientConnectEvent(clientEndpointIdentity.getChannelId(), clientEndpointIdentity.getUuid(), clientEndpointIdentity.getName(), clientEndpointIdentity.getChannelName(), clientEndpointIdentity.getEndpointId(), connectionPayload.has("payload") ? connectionPayload.get("payload") : null));
        this.clients.add(clientEndpointIdentity);
    }

    private void processDisconnection(String uuid, String name) {
        logger.debug(String.format("Client disconnected %s %s from channel %s", uuid, name, this.channel.getName()));
        Iterator<EndpointIdentity> allClients = this.clients.iterator();
        while (allClients.hasNext()) {
            EndpointIdentity client = allClients.next();
            if (!Objects.equals(client.getUuid(), uuid) || !Objects.equals(client.getName(), name)) continue;
            allClients.remove();
            this.fireClientDisconnectEvent(new ChannelClientConnectEvent(client.getChannelId(), client.getUuid(), client.getName(), client.getChannelName(), client.getEndpointId(), null));
            break;
        }
    }

    public void publish(String action, JSONObject actionPayload, AckListener ackListener) {
        for (EndpointIdentity client : this.clients) {
            EndpointIdentity destId = new EndpointIdentity(client.getChannelName(), null, client.getUuid(), client.getName(), client.getEndpointId());
            this.dispatch(destId.toJSON(), action, actionPayload, ackListener);
        }
    }

    @Override
    public boolean register(String action, ChannelAction listener) {
        return super.register(action, listener);
    }

    public boolean addProviderListener(ChannelProviderListener listener) {
        return this.providerListeners.add(listener);
    }

    public boolean removeProviderListener(ChannelProviderListener listener) {
        return this.providerListeners.remove(listener);
    }

    protected void fireClientConnectEvent(ChannelClientConnectEvent event) throws Exception {
        for (ChannelProviderListener listener : this.providerListeners) {
            listener.onClientConnect(event);
        }
    }

    protected void fireClientDisconnectEvent(ChannelClientConnectEvent event) {
        for (ChannelProviderListener listener : this.providerListeners) {
            listener.onClientDisconnect(event);
        }
    }
}

