/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.snapshot;

import com.openfin.desktop.DesktopConnection;
import com.openfin.desktop.channel.ChannelAction;
import com.openfin.desktop.snapshot.SnapshotSourceClient;
import com.openfin.desktop.snapshot.SnapshotSourceProvider;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotSource {
    private static final Logger logger = LoggerFactory.getLogger((String)SnapshotSource.class.getName());
    private final DesktopConnection desktopConnection;

    public SnapshotSource(DesktopConnection desktopConnection) {
        this.desktopConnection = desktopConnection;
    }

    public CompletionStage<SnapshotSourceProvider> initSnapshotSourceProviderAsync(String uuid, final SnapshotSourceProvider provider) {
        CompletableFuture<SnapshotSourceProvider> future = new CompletableFuture<SnapshotSourceProvider>();
        String cname = String.format("snapshot-source-provider-%s", uuid);
        logger.debug(String.format("initializing snapshot provider %s", cname));
        this.desktopConnection.getChannel(cname).createAsync().thenAccept(channelProvider -> {
            channelProvider.register("get-snapshot", new ChannelAction(){

                public JSONObject invoke(String action, Object payload, JSONObject senderIdentity) {
                    return provider.getSnapshot();
                }
            });
            channelProvider.register("apply-snapshot", new ChannelAction(){

                public JSONObject invoke(String action, Object payload, JSONObject senderIdentity) {
                    provider.applySnapshot((JSONObject)payload);
                    return null;
                }
            });
            future.complete(provider);
        });
        return future;
    }

    public CompletionStage<SnapshotSourceClient> createSnapshotSourceClientAsync(String uuid) {
        SnapshotSourceClient client = new SnapshotSourceClient(this.desktopConnection, uuid);
        return client.initChannelClientAsync();
    }
}

