/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.win32;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import com.openfin.desktop.DesktopUtils;
import com.openfin.desktop.Window;
import com.openfin.desktop.WindowBounds;
import com.openfin.desktop.win32.WinMessageHelper;
import com.openfin.desktop.win32.WindowProcCallback;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedWindow {
    private static final Logger logger = LoggerFactory.getLogger((String)EmbeddedWindow.class.getName());
    private long parentHwnd;
    private long childHwnd;
    private WindowBounds embedBounds;
    private Window window;
    private int previousStyle;
    private WinDef.HWND prevParent;
    private boolean embedded;

    public EmbeddedWindow(Window window) {
        this.window = window;
        this.embedded = false;
        this.childHwnd = -1L;
    }

    public void embed(long parentHwndId, WindowBounds embedBounds, final AckListener callback) {
        this.parentHwnd = parentHwndId;
        this.embedBounds = embedBounds;
        this.window.getNativeId(new AckListener(){

            @Override
            public void onSuccess(Ack ack) {
                if (EmbeddedWindow.this.childHwnd == -1L) {
                    String data = ack.getJsonObject().getString("data");
                    EmbeddedWindow.this.childHwnd = Long.decode(data);
                    WinDef.HWND childHwnd = EmbeddedWindow.this.toHwnd(EmbeddedWindow.this.childHwnd);
                    EmbeddedWindow.this.previousStyle = User32.INSTANCE.GetWindowLong(childHwnd, -16);
                }
                EmbeddedWindow.this.embedInto(new AckListener(){

                    @Override
                    public void onSuccess(Ack ack) {
                        try {
                            JSONObject targetObject = new JSONObject();
                            targetObject.put("uuid", (Object)EmbeddedWindow.this.window.getUuid());
                            targetObject.put("name", (Object)EmbeddedWindow.this.window.getName());
                            targetObject.put("parentHwnd", (Object)Long.toHexString(EmbeddedWindow.this.parentHwnd));
                            EmbeddedWindow.this.window.getConnection().sendAction("window-embedded", targetObject);
                            EmbeddedWindow.this.window.show();
                            EmbeddedWindow.this.window.focus();
                            if (callback != null) {
                                callback.onSuccess(ack);
                            }
                        }
                        catch (Exception ex) {
                            logger.error("Error registering embedded window", (Throwable)ex);
                        }
                    }

                    @Override
                    public void onError(Ack ack) {
                        if (callback != null) {
                            callback.onError(ack);
                        }
                    }
                });
            }

            @Override
            public void onError(Ack ack) {
                if (callback != null) {
                    callback.onError(ack);
                }
            }
        });
    }

    private void embedInto(AckListener callback) {
        block5: {
            try {
                if (!this.embedded) {
                    WinDef.HWND childHwnd = this.toHwnd(this.childHwnd);
                    WinDef.HWND parentHwnd = this.toHwnd(this.parentHwnd);
                    User32.INSTANCE.ShowWindow(childHwnd, 0);
                    int style = this.previousStyle;
                    style &= 0x6FFFFFFF;
                    logger.debug(String.format("set embedded style %x from %x ", style |= 0x2000000, this.previousStyle));
                    User32.INSTANCE.SetWindowLong(childHwnd, -16, style);
                    logger.debug(String.format("SetParent %s to parent %s", EmbeddedWindow.formatHwnd(childHwnd), EmbeddedWindow.formatHwnd(parentHwnd)));
                    this.prevParent = User32.INSTANCE.SetParent(childHwnd, parentHwnd);
                    logger.debug(String.format("Prev parent %s", EmbeddedWindow.formatHwnd(this.prevParent)));
                    logger.debug("MoveWindow  (" + this.embedBounds.getWidth() + "," + this.embedBounds.getHeight() + ")");
                    User32.INSTANCE.MoveWindow(childHwnd, this.embedBounds.getLeft().intValue(), this.embedBounds.getTop().intValue(), this.embedBounds.getWidth().intValue(), this.embedBounds.getHeight().intValue(), true);
                    this.installMessageHandlers();
                    this.embedded = true;
                } else {
                    logger.debug(String.format("already embedded %x", this.childHwnd));
                }
                if (callback != null) {
                    JSONObject msg = new JSONObject();
                    msg.put("success", (Object)Boolean.TRUE);
                    msg.put("hWndPreviousParent", Pointer.nativeValue((Pointer)this.prevParent.getPointer()));
                    DesktopUtils.successAck(callback, new Ack(msg, this.childHwnd));
                }
            }
            catch (Exception e) {
                logger.error("Error embedding window", (Throwable)e);
                if (callback == null) break block5;
                JSONObject msg = new JSONObject();
                msg.put("success", (Object)Boolean.FALSE);
                DesktopUtils.errorAck(callback, new Ack(msg, this.childHwnd));
            }
        }
    }

    private void unembed() {
        try {
            if (this.embedded) {
                WinMessageHelper.unhookWndProc(this.toHwnd(this.parentHwnd));
                logger.debug("unembed " + this.childHwnd);
                WinDef.HWND childHwnd = this.toHwnd(this.childHwnd);
                User32.INSTANCE.ShowWindow(childHwnd, 0);
                logger.debug(String.format("SetParent %s to %s", EmbeddedWindow.formatHwnd(childHwnd), EmbeddedWindow.formatHwnd(this.prevParent)));
                WinDef.HWND prevParent = User32.INSTANCE.SetParent(childHwnd, this.prevParent);
                logger.debug(String.format("Prev parent %s", EmbeddedWindow.formatHwnd(prevParent)));
                this.embedded = false;
            } else {
                logger.debug(String.format("already unembedded %x", this.childHwnd));
            }
        }
        catch (Exception e) {
            logger.error("Error unembedding window", (Throwable)e);
        }
    }

    public void embedComponentSizeChange(int left, int top, int width, int height) {
        logger.debug("MoveWindow  (" + left + "," + top + "," + width + "," + height + ")");
        Pointer p = Pointer.createConstant((long)this.childHwnd);
        WinDef.HWND childHwnd = new WinDef.HWND(p);
        User32.INSTANCE.MoveWindow(childHwnd, left, top, width, height, true);
    }

    private WinDef.HWND toHwnd(long hwnd) {
        return new WinDef.HWND(Pointer.createConstant((long)hwnd));
    }

    private static String formatHwnd(WinDef.HWND hwnd) {
        return String.format("%x", Pointer.nativeValue((Pointer)hwnd.getPointer()));
    }

    private void installMessageHandlers() {
        WindowProcCallback windowProcCallback = new WindowProcCallback(){

            @Override
            public boolean callback(WinDef.HWND hwnd, int msg, WinDef.WPARAM wp, Pointer lp) {
                boolean handled = false;
                try {
                    switch (msg) {
                        case 2: {
                            EmbeddedWindow.this.onWMDestroy(msg);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("Error processing callback", (Throwable)e);
                }
                return handled;
            }
        };
        try {
            logger.debug(String.format("hookWndProc %x", this.parentHwnd));
            WinMessageHelper.hookWndProc(this.toHwnd(this.parentHwnd), windowProcCallback);
        }
        catch (Throwable e) {
            logger.error("Error initializing", e);
        }
    }

    private void onWMDestroy(int msg) {
        logger.debug("onWMDestroy");
        this.cleanup();
    }

    private void cleanup() {
        logger.debug("cleaning up");
        try {
            this.unembed();
        }
        catch (Exception ex) {
            logger.info("Error cleaning up", (Throwable)ex);
        }
    }
}

