/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.win32;

import com.openfin.desktop.win32.WindowProcCallback;
import com.sun.jna.Callback;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinMessageHelper {
    public static final int WM_CAPTURECHANGED = 533;
    public static final int WM_DESTROY = 2;
    public static final int WM_ENTERSIZEMOVE = 561;
    public static final int WM_ERASEBKGND = 20;
    public static final int WM_EXITSIZEMOVE = 562;
    public static final int WM_KEYDOWN = 256;
    public static final int WM_KEYUP = 257;
    public static final int WM_KILLFOCUS = 8;
    public static final int WM_LBUTTONDOWN = 513;
    public static final int WM_LBUTTONUP = 514;
    public static final int WM_MOUSEMOVE = 512;
    public static final int WM_MOVE = 3;
    public static final int WM_MOVING = 534;
    public static final int WM_NCLBUTTONDBLCLK = 163;
    public static final int WM_NCLBUTTONUP = 162;
    public static final int WM_NOTIFY = 78;
    public static final int WM_SETFOCUS = 7;
    public static final int WM_SIZE = 5;
    public static final int WM_SIZING = 532;
    public static final int WM_SYSCOMMAND = 274;
    public static final int WM_WINDOWPOSCHANGED = 71;
    public static final int WM_WINDOWPOSCHANGING = 70;
    public static final int WM_PAINT = 15;
    public static final int SC_CLOSE = 61536;
    public static final int SC_MAXIMIZE = 61488;
    public static final int SC_MINIMIZE = 61472;
    public static final int SC_RESTORE = 61728;
    public static final int SWP_HIDEWINDOW = 128;
    public static final int SWP_NOMOVE = 2;
    public static final int SWP_NOSIZE = 1;
    public static final int SWP_SHOWWINDOW = 64;
    private static final Logger logger = LoggerFactory.getLogger((String)WinMessageHelper.class.getName());
    public static CustomUser32 customUser32;
    private static Map<WinDef.HWND, HookProcInfo> callbackMap;

    public static void hookWndProc(WinDef.HWND hwnd, WindowProcCallback callback) {
        logger.debug("hookWndProc " + hwnd);
        if (callbackMap.get(hwnd) == null) {
            Pointer prev;
            CustomWindowProc customWindowProc = new CustomWindowProc(){

                @Override
                public WinDef.LRESULT callback(WinDef.HWND hwnd, int uMsg, WinDef.WPARAM wParam, Pointer lParam) {
                    logger.trace("callback uMsg " + uMsg);
                    HookProcInfo hpi = (HookProcInfo)callbackMap.get(hwnd);
                    if (hpi != null) {
                        boolean handled = hpi.winProcCallback.callback(hwnd, uMsg, wParam, lParam);
                        if (!handled) {
                            return customUser32.CallWindowProc(hpi.prevWndProc, hwnd, uMsg, wParam, lParam);
                        }
                        logger.debug("uMsg handled " + uMsg);
                        return new WinDef.LRESULT(1L);
                    }
                    logger.debug("custom windowproc missing. calling default");
                    return customUser32.DefWindowProc(hwnd, uMsg, wParam, lParam);
                }
            };
            if (Platform.is64Bit()) {
                logger.debug("installing 64b WNDPROC " + customWindowProc);
                prev = customUser32.SetWindowLongPtr(hwnd, -4, customWindowProc);
            } else {
                logger.debug("installing WNDPROC " + customWindowProc);
                prev = customUser32.SetWindowLong(hwnd, -4, customWindowProc);
            }
            logger.debug("saving WNDPROC " + prev);
            HookProcInfo info = new HookProcInfo();
            info.hwnd = hwnd;
            info.prevWndProc = prev;
            info.winProcCallback = callback;
            info.customWindowProc = customWindowProc;
            callbackMap.put(hwnd, info);
        } else {
            logger.error("hookWndProc custom winProc already installed " + hwnd);
        }
    }

    public static void unhookWndProc(WinDef.HWND hwnd) {
        logger.debug("unhookWndProc" + hwnd);
        HookProcInfo hpi = callbackMap.get(hwnd);
        if (hpi != null) {
            if (Platform.is64Bit()) {
                logger.debug("installing 64b WNDPROC " + hpi.prevWndProc);
                User32.INSTANCE.SetWindowLongPtr(hwnd, -4, hpi.prevWndProc);
            } else {
                logger.debug("installing WNDPROC " + hpi.prevWndProc);
                customUser32.SetWindowLong(hwnd, -4, hpi.prevWndProc);
            }
            callbackMap.remove(hwnd);
        }
    }

    public static void main(String[] argv) {
        try {
            String cpuRegistryRoot = "HARDWARE\\DESCRIPTION\\System\\CentralProcessor";
            String[] processorIds = Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"HARDWARE\\DESCRIPTION\\System\\CentralProcessor");
            String processorId = processorIds[0];
            String cpuRegistryPath = "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\" + processorId;
            System.out.println(Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)cpuRegistryPath, (String)"ProcessorNameString").trim());
            String settings = "SOFTWARE\\OpenFin\\RVM\\Settings";
            System.out.println(Advapi32Util.registryGetIntValue((WinReg.HKEY)WinReg.HKEY_CURRENT_USER, (String)settings, (String)"cleanUnusedRuntimes"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        callbackMap = Collections.synchronizedMap(new HashMap());
        try {
            customUser32 = (CustomUser32)Native.loadLibrary((String)"user32", CustomUser32.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
        }
        catch (Exception e) {
            logger.error("Error initializing user32 lib", (Throwable)e);
        }
    }

    private static class HookProcInfo {
        public WinDef.HWND hwnd;
        public Pointer prevWndProc;
        public WindowProcCallback winProcCallback;
        public CustomWindowProc customWindowProc;

        private HookProcInfo() {
        }
    }

    public static interface CustomUser32
    extends StdCallLibrary {
        public static final int GWL_HWNDPARENT = -8;

        public Pointer SetWindowLong(WinDef.HWND var1, int var2, CustomWindowProc var3);

        public Pointer SetWindowLong(WinDef.HWND var1, int var2, Pointer var3);

        public Pointer SetWindowLongPtr(WinDef.HWND var1, int var2, CustomWindowProc var3);

        public WinDef.LRESULT CallWindowProc(Pointer var1, WinDef.HWND var2, int var3, WinDef.WPARAM var4, Pointer var5);

        public WinDef.LRESULT DefWindowProc(WinDef.HWND var1, int var2, WinDef.WPARAM var3, Pointer var4);

        public boolean GetCursorPos(WinDef.POINT var1);

        public boolean ChangeWindowMessageFilterEx(WinDef.HWND var1, int var2, WinDef.DWORD var3, Pointer var4);
    }

    private static interface CustomWindowProc
    extends Callback {
        public WinDef.LRESULT callback(WinDef.HWND var1, int var2, WinDef.WPARAM var3, Pointer var4);
    }
}

