package com.openfin.desktop;

import org.json.JSONObject;

import java.util.EventObject;

/**
 * An Event object is passed to EventListener when the registered event occurs.
 * @author wche
 * @since 2/9/14
 */
public class ActionEvent extends EventObject {
    private String type;
    private JSONObject eventObject;

    /**
     * Constructor
     * @param type Event type
     * @param eventObject Data included in the event
     * @param source Event source
     */
    public ActionEvent(String type, JSONObject eventObject, Object source) {
        super(source);
        this.type = type;
        this.eventObject = eventObject;
    }

    /**
     * Gets event type
     * @return event type
     */
    public String getType() {
        return type;
    }

    /**
     * Gets event data object
     * @return event data object
     */
    public JSONObject getEventObject() {
        return this.eventObject;
    }

}
