package com.openfin.desktop.animation;

import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * A class representing a collection of transitions for a Window animation.
 */
public class AnimationTransitions {
    private final static Logger logger = LoggerFactory.getLogger(AnimationTransitions.class.getName());

    private OpacityTransition opacity;
    private SizeTransition size;
    private PositionTransition position;

    /**
     * Helper utility for determining if an underliying transition contains configured data
     * @param transition Transiton in JSON format
     * @return true if the transition is empty
     */
    private boolean isTransitionEmpty(AbstractAnimation transition) {
        return transition == null || transition.toJsonObject().length() == 0;
    }


    public JSONObject toJsonObject() {
        JSONObject container = new JSONObject();
        try {
            if (!this.isTransitionEmpty(this.opacity)) {
                container.put("opacity", this.opacity.toJsonObject());
            }
            if (!this.isTransitionEmpty(this.size)) {
                container.put("size", this.size.toJsonObject());
            }
            if (!this.isTransitionEmpty(this.position)) {
                container.put("position", this.position.toJsonObject());
            }
            } catch (Exception e) {
            logger.error("Error toJSONObject", e);
        }
        return container;
    }

    /**
     * Sets Opacity transition
     * @return Opacity transition
     */
    public OpacityTransition getOpacity() {
        return opacity;
    }

    /**
     * Sets opacity transition
     * @param opacity Opacity transition
     */
    public void setOpacity(OpacityTransition opacity) {
        this.opacity = opacity;
    }

    /**
     * Gets size transition
     * @return Size transition
     */
    public SizeTransition getSize() {
        return size;
    }

    /**
     * Sets size transition
     * @param size size of the transition
     */
    public void setSize(SizeTransition size) {
        this.size = size;
    }

    /**
     * Gets position transition
     * @return Position transition
     */
    public PositionTransition getPosition() {
        return position;
    }

    /**
     * Sets position transition
     * @param position position for the transition
     */
    public void setPosition(PositionTransition position) {
        this.position = position;
    }
}
