package com.openfin.desktop.net;

import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.common.scopes.SimpleContainerScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.openfin.desktop.OpenFinThreadPool;

/**
 * <p>Make singleton of WebSocketClient. If system property
 * "com.openfin.desktop.threads.jetty=nThreads" is defined, it creates
 * {@link com.openfin.desktop.OpenFinThreadPool OpenFinThreadPool} with fixed
 * thread pool size of nThread and will be used by jetty container. </p> 
 *
 * Created by wche on 9/22/2016.
 */
class WebSocketClientFactory {
    private static Logger logger = LoggerFactory.getLogger(WebSocketClientFactory.class.getName());
    private static WebSocketClient client;

    static synchronized WebSocketClient getWebSocketClient() {
        if (client == null) {
            logger.debug("Creating WebSocketClient");
            String strJettyThreads = System.getProperty("com.openfin.desktop.threads.jetty");
            if (strJettyThreads != null) {
            	int jettyThreads = Integer.parseInt(strJettyThreads);
                SimpleContainerScope scope = new SimpleContainerScope(new WebSocketPolicy(WebSocketBehavior.CLIENT), null, new OpenFinThreadPool("OpenFinJetty", jettyThreads), null);
                HttpClient httpClient = new HttpClient(new HttpClientTransportOverHTTP(Math.max(1, Math.min(ProcessorUtils.availableProcessors() / 2, jettyThreads - 1))), null);
                httpClient.setExecutor(scope.getExecutor());
                try {
					httpClient.start();
				}
				catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
                client = new WebSocketClient(scope, null, null, httpClient);
            }
            else {
              client = new WebSocketClient();
            }
            try {
                logger.debug("Starting WebSocketClient");
                client.start();
            } catch (Exception e) {
                logger.error("Error creating WebSocketClient", e);
            }
        }
        return client;
    }

    static synchronized void stopWebSocketClient() {
        if (client != null) {
            try {
                if (client.getOpenSessions().isEmpty()) {
                    logger.debug("No live sessions.  closing");
                    client.stop();
                    client = null;
                }
            } catch (Exception e) {
                logger.error("Error stopping WebSocketClient", e);
            }
        }
    }
}
