package com.openfin.desktop.notifications;

import org.json.JSONObject;

import com.openfin.desktop.JsonBean;

/**
 * Status object returned by the Provider.
 * @author Anthony
 *
 */
public class ProviderStatus extends JsonBean {
	
	public ProviderStatus(JSONObject jsonObject) {
		super(jsonObject);
	}

	/**
	 * The current connection status from the Client to the Provider.
	 * @return true if connected to the provider.
	 */
	public boolean isConnected() {
		return this.getBooleanValue("connected");
	}
	
	/**
	 * Get the version number of the Provider.
	 * @return The version number of the Provider. If the Provider is not connected, this will be null.
	 */
	public String getVersion() {
		return this.getString("version");
	}
}

