package com.openfin.desktop.notifications.events;

import org.json.JSONObject;

import com.openfin.desktop.JsonBean;
import com.openfin.desktop.notifications.NotificationOptions;

public class NotificationEvent extends JsonBean {

	private NotificationOptions notificationOpts;

	public NotificationEvent(JSONObject json) {
		super(json);
	}
	
	public String getType() {
		return this.json.getString("type");
	}

	public NotificationOptions getNotificationOptions() {
		if (this.notificationOpts == null) {
			this.notificationOpts = new NotificationOptions(this.json.getJSONObject("notification"));
		}
		return notificationOpts;
	}
}
