package com.openfin.desktop.test;

import com.openfin.desktop.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.System;
import java.util.concurrent.CountDownLatch;

public class Test implements DesktopStateListener {
    private static final Logger logger = LoggerFactory.getLogger(Test.class.getName());

    private DesktopConnection desktopConnection;
    private static final CountDownLatch latch = new CountDownLatch(2);

    public Test() {
        try {
            desktopConnection = new DesktopConnection("test");
            RuntimeConfiguration configuration = new RuntimeConfiguration();
            configuration.setRuntimeVersion("canary");
            desktopConnection.connect(configuration, this, 60);
        }
        catch (Exception ex) {
            logger.error("Error launching Runtime", ex);
        }
    }

    @Override
    public void onReady() {
        OpenFinRuntime r = new OpenFinRuntime(this.desktopConnection);
        r.resolveProxy("https://openfin.co", new AckListener() {
            @Override
            public void onSuccess(Ack ack) {
                System.out.println(String.format("%s", ack.getData().toString()));
                latch.countDown();
            }

            @Override
            public void onError(Ack ack) {

            }
        });
        r.resolveProxy("https://google.com", new AckListener() {
            @Override
            public void onSuccess(Ack ack) {
                System.out.println(String.format("%s", ack.getData().toString()));
                latch.countDown();
            }

            @Override
            public void onError(Ack ack) {

            }
        });
    }

    @Override
    public void onClose(String error) {

    }

    @Override
    public void onError(String reason) {

    }

    @Override
    public void onMessage(String message) {

    }

    @Override
    public void onOutgoingMessage(String message) {

    }

    public static void main(String[] args) {
        try {
            new Test();
            latch.await();
        }
        catch (InterruptedException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }

        java.lang.System.exit(0);
    }

}
