/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop;

import com.openfin.desktop.JsonBean;
import com.openfin.desktop.WindowOptions;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationOptions
extends JsonBean {
    private static final Logger logger = LoggerFactory.getLogger((String)ApplicationOptions.class.getName());
    WindowOptions mainWindowOptions;

    public ApplicationOptions(JSONObject options) {
        super(options);
    }

    public ApplicationOptions(String name, String uuid, String url) {
        this.json = new JSONObject();
        try {
            this.json.put("name", (Object)name);
            this.json.put("uuid", (Object)uuid);
            this.json.put("url", (Object)url);
        }
        catch (JSONException e) {
            logger.error("Error populating options", (Throwable)e);
        }
    }

    public String getName() {
        return this.getString("name");
    }

    public String getUUID() {
        return this.getString("uuid");
    }

    public String getURL() {
        return this.getString("url");
    }

    public void setMainWindowOptions(WindowOptions options) {
        this.mainWindowOptions = options;
    }

    public WindowOptions getMainWindowOptions() {
        return this.mainWindowOptions;
    }

    public void setApplicationIcon(String applicationIcon) {
        try {
            this.json.put("applicationIcon", (Object)applicationIcon);
        }
        catch (JSONException e) {
            logger.error("Error setting applicationIcon");
        }
    }

    public String getApplicationIcon() {
        return this.getString("applicationIcon");
    }

    public void setVersion(String version) {
        try {
            this.json.put("version", (Object)version);
        }
        catch (JSONException e) {
            logger.error("Error setting version");
        }
    }

    public String getVersion() {
        return this.getString("version");
    }

    @Override
    public JSONObject getJson() {
        if (this.mainWindowOptions != null) {
            this.setJsonBean("mainWindowOptions", this.mainWindowOptions);
        }
        return super.getJson();
    }
}

