/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import com.openfin.desktop.ActionEvent;
import com.openfin.desktop.Application;
import com.openfin.desktop.ApplicationOptions;
import com.openfin.desktop.DesktopException;
import com.openfin.desktop.DesktopIOException;
import com.openfin.desktop.DesktopStateListener;
import com.openfin.desktop.DesktopUtils;
import com.openfin.desktop.EventListener;
import com.openfin.desktop.ExternalMessageListener;
import com.openfin.desktop.ExternalMessageResultHandlerFactory;
import com.openfin.desktop.InterApplicationBus;
import com.openfin.desktop.JsonUtils;
import com.openfin.desktop.OpenFinRuntime;
import com.openfin.desktop.OpenFinThreadPool;
import com.openfin.desktop.PortDiscoveryHandler;
import com.openfin.desktop.RVMOptions;
import com.openfin.desktop.RuntimeConfiguration;
import com.openfin.desktop.RuntimeLauncher;
import com.openfin.desktop.channel.Channel;
import com.openfin.desktop.channel.EndpointIdentity;
import com.openfin.desktop.interop.Interop;
import com.openfin.desktop.net.WebSocketConnection;
import com.openfin.desktop.net.WebSocketEventHandler;
import com.openfin.desktop.net.WebSocketException;
import com.openfin.desktop.net.WebSocketMessage;
import com.openfin.desktop.platform.Platform;
import com.openfin.desktop.platform.PlatformOptions;
import com.openfin.desktop.snapshot.SnapshotSource;
import com.openfin.desktop.win32.DesktopPortHandler;
import com.openfin.desktop.win32.NamedPipePortHandler;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicLong;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesktopConnection {
    private static final Logger logger = LoggerFactory.getLogger((String)DesktopConnection.class.getName());
    private Map<Long, CallBackSourcePair> callbacks;
    private Map<Integer, CallBackSourcePair> notificationListenerMap = new ConcurrentHashMap<Integer, CallBackSourcePair>();
    private Map<String, Map<String, Map<String, List<CallBackSourcePair>>>> applicationEventCallbackMap = new ConcurrentHashMap<String, Map<String, Map<String, List<CallBackSourcePair>>>>();
    private Map<String, Map<String, List<CallBackSourcePair>>> systemEventCallbackMap = new ConcurrentHashMap<String, Map<String, List<CallBackSourcePair>>>();
    private Map<String, Map<String, Map<String, Map<String, List<CallBackSourcePair>>>>> webContentEventCallbackMap = new ConcurrentHashMap<String, Map<String, Map<String, Map<String, List<CallBackSourcePair>>>>>();
    private Map<String, Map<String, List<CallBackSourcePair>>> channelEventCallbackMap = new ConcurrentHashMap<String, Map<String, List<CallBackSourcePair>>>();
    private List<ExternalMessageListenerSourcePair> externalMessageHandlers = new CopyOnWriteArrayList<ExternalMessageListenerSourcePair>();
    private WebSocketConnection websocket;
    private JSONObject jsonMsg;
    private boolean connected = false;
    private String uuid;
    private String host;
    private Integer port;
    private int timeout;
    private long waitStartTime;
    private boolean opened = false;
    private boolean authRequested = false;
    private String authorizationAction;
    private String authorizationType;
    private AtomicLong messageId = new AtomicLong(0L);
    private Integer notificationCount = 1;
    private JSONObject notificationPayload;
    private String runtimeSecurityRealm;
    private String additionalRuntimeArguments;
    private String rdmUrl;
    private int devtoolsPort;
    private String runtimeAssetsUrl;
    private String additionalRvmArguments;
    private DesktopStateListener listener;
    private PortDiscoveryHandler portDiscoveryHandler;
    private static volatile String processId;
    private Timer timer;
    private boolean disconnecting = false;
    private InterApplicationBus busInstance;
    private long startTime;
    private long eventTime;
    private long authReqMsgId;
    private EventListener portDiscoveryEventListener;
    private RuntimeConfiguration activeConfiguration;
    private ExecutorService threadPoolMsgOut;
    private ExecutorService threadPoolMsgIn;
    private Map<String, Channel> channels = new ConcurrentHashMap<String, Channel>();
    private Interop interop;
    private SnapshotSource snapshotSource;

    public DesktopConnection(String uuid) throws DesktopException {
        this(uuid, null, null);
    }

    public DesktopConnection(String uuid, String host, Integer port) throws DesktopException {
        if (uuid == null || uuid.trim().isEmpty()) {
            logger.warn("WARNING : Application does not have UUID declared which is recommended and required for support purposes. For more information, please contact support@openfin.co.");
            throw new DesktopException("Invalid uuid: ");
        }
        this.uuid = uuid;
        this.host = "localhost";
        this.port = port;
        String strThreadsMessageOut = System.getProperty("com.openfin.desktop.threads.message.out");
        this.threadPoolMsgOut = strThreadsMessageOut != null ? new OpenFinThreadPool("OpenFinMsgOut", Integer.parseInt(strThreadsMessageOut)) : ForkJoinPool.commonPool();
        String strThreadsMessageIn = System.getProperty("com.openfin.desktop.threads.message.in", "1");
        this.threadPoolMsgIn = strThreadsMessageIn != null ? new OpenFinThreadPool("OpenFinMsgIn", Integer.parseInt(strThreadsMessageIn)) : ForkJoinPool.commonPool();
        this.callbacks = new ConcurrentHashMap<Long, CallBackSourcePair>();
        this.jsonMsg = new JSONObject();
        this.busInstance = new InterApplicationBus(this);
    }

    private void timingEvent(String event) {
        long now = System.currentTimeMillis();
        double time = (double)(now - this.eventTime) / 1000.0;
        logger.debug("Event:" + event + " secs:" + time);
        this.eventTime = now;
    }

    private void startEvent(String event) {
        long now = System.currentTimeMillis();
        double time = (double)(now - this.startTime) / 1000.0;
        logger.debug("Total Time: " + event + " secs:" + time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequestAuthorization() throws DesktopException, DesktopIOException {
        if (!this.authRequested) {
            JSONObject json = new JSONObject();
            try {
                json.put("action", (Object)this.authorizationAction);
                JsonUtils.updateValue(json, "action", this.authorizationAction);
                JSONObject client = new JSONObject();
                client.put("type", (Object)"java");
                client.put("version", (Object)(OpenFinRuntime.getAdapterVersion() == null ? "N/A" : OpenFinRuntime.getAdapterVersion()));
                client.put("javaVersion", (Object)System.getProperty("java.version"));
                JSONObject payload = new JSONObject();
                payload.put("uuid", (Object)this.uuid);
                payload.put("type", (Object)this.authorizationType);
                payload.put("licenseKey", (Object)(this.activeConfiguration.getLicenseKey() == null || this.activeConfiguration.getLicenseKey().trim().isEmpty() ? "N/A" : this.activeConfiguration.getLicenseKey()));
                payload.put("client", (Object)client);
                payload.put("configUrl", (Object)(this.activeConfiguration.getManifestLocation() != null ? this.activeConfiguration.getManifestLocation() : this.activeConfiguration.getGeneratedManifestLocation()));
                Class<DesktopConnection> clazz = DesktopConnection.class;
                synchronized (DesktopConnection.class) {
                    if (processId == null) {
                        processId = DesktopConnection.getProcessId("N/A");
                        payload.put("pid", (Object)processId);
                    } else {
                        logger.debug("skipping passing pid");
                    }
                    // ** MonitorExit[var4_6] (shouldn't be in output)
                    json.put("payload", (Object)payload);
                    this.authReqMsgId = this.getNextMessageId();
                    json.put("messageId", this.authReqMsgId);
                    String msg = json.toString();
                    logger.debug("sending message: " + msg);
                    if (this.listener != null) {
                        this.listener.onOutgoingMessage(msg);
                    }
                    this.websocket.send(msg);
                }
            }
            catch (JSONException je) {
                throw new DesktopException((Exception)((Object)je));
            }
            catch (WebSocketException wex) {
                throw new DesktopIOException(wex);
            }
        }
    }

    public void connect(RuntimeConfiguration configuration, DesktopStateListener listener, int timeout) throws DesktopIOException, IOException {
        if (configuration.getLicenseKey() == null || configuration.getLicenseKey().trim().isEmpty()) {
            logger.warn("WARNING : Application does not have a valid OpenFin license key implemented. To obtain a valid license key or to begin your 30 days of free support, please contact support@openfin.co.");
        }
        if (configuration.getRuntimePort() > 0) {
            this.port = configuration.getRuntimePort();
            this.activeConfiguration = configuration;
            this.timeout = timeout;
            this.connect(listener);
        } else if (this.portDiscoveryEventListener == null) {
            this.eventTime = this.startTime = System.currentTimeMillis();
            this.listener = listener;
            this.port = null;
            this.timeout = timeout;
            this.activeConfiguration = configuration;
            this.portDiscoveryEventListener = this.initPortDiscoveryEventListener(configuration, listener, timeout);
            if (!configuration.isDoNotLaunch()) {
                try {
                    this.portDiscoveryHandler = this.initDesktopPortHandler(this.portDiscoveryEventListener, configuration);
                }
                catch (Exception ex) {
                    logger.error("unable to initDesktopPortHandler", (Throwable)ex);
                    throw new DesktopIOException(ex);
                }
            }
            RuntimeLauncher.launchVersion(configuration, this.uuid);
        } else {
            logger.error("Already waiting to connect to a version");
        }
    }

    private boolean matchRuntimeInstance(String requestedVersion, String securityRealm, RuntimeConfiguration configuration) {
        if (configuration.getRuntimeVersion() != null && configuration.getSecurityRealm() != null && configuration.getRuntimeVersion().equals(requestedVersion) && configuration.getSecurityRealm().equals(securityRealm)) {
            logger.debug("matched Runtime version and security realm");
            return true;
        }
        if (configuration.getRuntimeFallbackVersion() != null && configuration.getSecurityRealm() != null && configuration.getRuntimeFallbackVersion().equals(requestedVersion) && configuration.getSecurityRealm().equals(securityRealm)) {
            logger.debug("matched Runtime fullback version and security realm");
            return true;
        }
        if (configuration.getRuntimeVersion() != null && configuration.getSecurityRealm() == null && configuration.getRuntimeVersion().equals(requestedVersion) && securityRealm == null) {
            logger.debug("matched Runtime version and null security realm");
            return true;
        }
        if (configuration.getRuntimeFallbackVersion() != null && configuration.getSecurityRealm() == null && configuration.getRuntimeFallbackVersion().equals(requestedVersion) && securityRealm == null) {
            logger.debug("matched Runtime fallback version and null security realm");
            return true;
        }
        return false;
    }

    private EventListener initPortDiscoveryEventListener(final RuntimeConfiguration configuration, final DesktopStateListener listener, int timeout) {
        return new EventListener(){

            @Override
            public void eventReceived(ActionEvent actionEvent) {
                if (actionEvent.getType().equals("TIMEOUT")) {
                    logger.error("timed out on connectionToVersion");
                    DesktopConnection.this.portDiscoveryHandler.removeEventListener(DesktopConnection.this.portDiscoveryEventListener);
                    DesktopConnection.this.portDiscoveryEventListener = null;
                    listener.onError("Connection timed out");
                } else {
                    String requestedSecurityRealm;
                    JSONObject runtimeInfo = actionEvent.getEventObject();
                    Integer port = JsonUtils.getIntegerValue(runtimeInfo, "port", null);
                    String requestedVersion = JsonUtils.getStringValue(runtimeInfo, "requestedVersion", null);
                    if (DesktopConnection.this.matchRuntimeInstance(requestedVersion, requestedSecurityRealm = JsonUtils.getStringValue(runtimeInfo, "securityRealm", null), configuration)) {
                        String runVersion = JsonUtils.getStringValue(runtimeInfo, "version", null);
                        if (port == null) {
                            listener.onError("Port for version " + configuration.getRuntimeVersion() + " not found in COPYDATA");
                        } else if (runVersion == null || runVersion.length() == 0) {
                            listener.onError("Version for version " + configuration.getRuntimeVersion() + " not found in COPYDATA");
                        } else if (DesktopConnection.this.port == null) {
                            DesktopConnection.this.port = port;
                            logger.debug("Runtime version " + runVersion + " at port " + port);
                            try {
                                DesktopConnection.this.connect(listener);
                            }
                            catch (Exception e) {
                                logger.error("Error connecting to desktop", (Throwable)e);
                                listener.onError(e.getMessage());
                            }
                        } else {
                            logger.debug("Port already set at " + DesktopConnection.this.port + ", ignoring " + port);
                        }
                        DesktopConnection.this.portDiscoveryHandler.removeEventListener(DesktopConnection.this.portDiscoveryEventListener);
                        DesktopConnection.this.portDiscoveryEventListener = null;
                    } else {
                        logger.debug("RequestedVersion " + requestedVersion + " mismatches " + configuration.getRuntimeVersion() + ", ignoring...");
                    }
                }
            }
        };
    }

    private PortDiscoveryHandler initDesktopPortHandler(EventListener portDiscoveryEventListener, RuntimeConfiguration runtimeConfiguration) {
        PortDiscoveryHandler handler;
        if (runtimeConfiguration.isUseNamedPipePortDiscovery() || !DesktopUtils.isWindows()) {
            long randomNum = (long)Math.floor(Math.random() * 100000.0);
            String pipeName = "OpenfinJavaAdapter." + System.currentTimeMillis() + "." + randomNum;
            handler = DesktopUtils.isWindows() ? new NamedPipePortHandler(pipeName) : new com.openfin.desktop.nix.NamedPipePortHandler(pipeName);
            runtimeConfiguration.setAdditionalRuntimeArguments("--v=1 --runtime-information-channel-v6=" + handler.getEffectivePipeName());
            handler.registerEventListener(portDiscoveryEventListener, this.timeout);
        } else {
            handler = DesktopPortHandler.getInstance();
            handler.registerEventListener(portDiscoveryEventListener, this.timeout);
        }
        return handler;
    }

    public void disconnect() throws DesktopException {
        this.disconnect(null);
    }

    protected void disconnect(String reason) throws DesktopException {
        this.disconnecting = true;
        try {
            if (this.timer != null) {
                this.timer.cancel();
            }
            this.threadPoolMsgOut.shutdown();
            this.websocket.close(reason);
        }
        catch (WebSocketException e) {
            logger.error("Error disconnecting Runtime", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void exit() throws DesktopException {
        try {
            this.sendAction("exit-desktop", new JSONObject());
        }
        catch (Exception e) {
            logger.error("Error existing Runtime", (Throwable)e);
            throw new DesktopException(e);
        }
    }

    public InterApplicationBus getInterApplicationBus() {
        return this.busInstance;
    }

    public Integer getPort() {
        return this.port;
    }

    public void sendAction(String action, JSONObject payload) throws DesktopException {
        this.sendAction(action, payload, null);
    }

    private synchronized void sendAction(String action, JSONObject payload, Long newMessageId) throws DesktopException {
        if (this.isConnected()) {
            try {
                this.jsonMsg.put("action", (Object)action);
                if (newMessageId == null) {
                    newMessageId = this.getNextMessageId();
                }
                this.jsonMsg.put("messageId", (Object)newMessageId);
                if (payload != null) {
                    this.jsonMsg.put("payload", (Object)payload);
                } else {
                    this.jsonMsg.remove("payload");
                }
                String msg = this.jsonMsg.toString();
                if (logger.isDebugEnabled()) {
                    logger.debug("Sending: " + msg);
                }
                if (this.listener != null) {
                    this.listener.onOutgoingMessage(msg);
                }
                this.websocket.send(msg);
            }
            catch (Exception e) {
                logger.error("Error sending action", (Throwable)e);
                throw new DesktopException(e);
            }
        } else {
            logger.warn("Not connected to sendAction " + this.jsonMsg);
        }
    }

    private long getNextMessageId() {
        return this.messageId.getAndIncrement();
    }

    public CompletableFuture<Ack> sendActionAsync(String action, JSONObject payload, Object source) {
        CompletableFuture ackFuture = new CompletableFuture();
        CompletableFuture<Void> sendActionFuture = CompletableFuture.runAsync(() -> {
            if (this.isConnected()) {
                CallBackSourcePair lsp = new CallBackSourcePair(ackFuture, source);
                Long msgId = this.getNextMessageId();
                this.callbacks.put(msgId, lsp);
                try {
                    this.sendAction(action, payload, msgId);
                }
                catch (DesktopException e) {
                    throw new RuntimeException("error sending action, action: " + action + ", payload: " + payload);
                }
            } else {
                throw new RuntimeException("error sending action, not connected, action: " + action + ", payload: " + payload);
            }
        }, this.threadPoolMsgOut);
        return sendActionFuture.thenCombine((CompletionStage)ackFuture, (nothing, ack) -> ack);
    }

    public void sendAction(String action, JSONObject payload, AckListener ackListener, Object source) {
        CompletableFuture<Ack> f = this.sendActionAsync(action, payload, source);
        f.thenAccept(ack -> {
            if (ack.isSuccessful()) {
                DesktopUtils.successAck(ackListener, ack);
            } else {
                DesktopUtils.errorAck(ackListener, ack);
            }
        });
    }

    private void runDesktop(final String desktopPath, final String commandLine) throws DesktopIOException {
        logger.debug("run desktop from " + desktopPath + " " + commandLine);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    OutputStream stdin = null;
                    InputStream stderr = null;
                    InputStream stdout = null;
                    Process process = Runtime.getRuntime().exec("cmd");
                    stdin = process.getOutputStream();
                    stderr = process.getErrorStream();
                    stdout = process.getInputStream();
                    String line = "start " + desktopPath + " " + commandLine + "\n";
                    logger.debug(line);
                    stdin.write(line.getBytes());
                    stdin.flush();
                    stdin.close();
                    BufferedReader brCleanUp = new BufferedReader(new InputStreamReader(stdout));
                    while ((line = brCleanUp.readLine()) != null) {
                        logger.debug("[Stdout] " + line);
                    }
                    brCleanUp.close();
                    brCleanUp = new BufferedReader(new InputStreamReader(stderr));
                    while ((line = brCleanUp.readLine()) != null) {
                        logger.debug("[Stderr] " + line);
                    }
                    brCleanUp.close();
                }
                catch (Exception e1) {
                    logger.error("Error starting Runtime", (Throwable)e1);
                }
            }
        };
        thread.setName(this.getClass().getName() + ".runDesktop");
        thread.start();
    }

    public void connect(DesktopStateListener listener) {
        if (this.activeConfiguration == null) {
            this.activeConfiguration = new RuntimeConfiguration();
        }
        this.connect("file-token", listener);
    }

    private void connect(String type, final DesktopStateListener listener) {
        if (this.connected) {
            listener.onError("Desktop websocket already connected");
            return;
        }
        this.authorizationAction = "request-external-authorization";
        this.authorizationType = type;
        this.authRequested = false;
        try {
            if (this.host == null) {
                throw new WebSocketException("");
            }
            URI uri = new URI("ws://" + this.host + ":" + this.port + "/");
            logger.debug("opening websocket " + uri.toString());
            this.websocket = new WebSocketConnection(uri);
        }
        catch (Exception ex) {
            logger.error("Error connecting to Runtime", (Throwable)ex);
            listener.onError(ex.getMessage());
        }
        this.websocket.setEventHandler(new WebSocketEventHandler(){

            @Override
            public void onOpen() {
                try {
                    if (DesktopConnection.this.activeConfiguration.getMaxMessageSize() > 0) {
                        logger.debug(String.format("setting max message size %d", DesktopConnection.this.activeConfiguration.getMaxMessageSize()));
                        DesktopConnection.this.websocket.setMaxMessageSize(DesktopConnection.this.activeConfiguration.getMaxMessageSize());
                    }
                    DesktopConnection.this.timingEvent("onOpen");
                    DesktopConnection.this.disconnecting = false;
                    DesktopConnection.this.opened = true;
                    DesktopConnection.this.cancelConnectWaitTimer();
                    DesktopConnection.this.sendRequestAuthorization();
                }
                catch (Exception authEx) {
                    logger.error("Error onOpen", (Throwable)authEx);
                    listener.onError(authEx.getMessage());
                }
            }

            @Override
            public void onMessage(WebSocketMessage message) {
                DesktopConnection.this.threadPoolMsgIn.submit(() -> {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Received message: " + message.getText());
                    }
                    listener.onMessage(message.getText());
                    try {
                        JSONObject json = new JSONObject(message.getText());
                        String action = json.getString("action");
                        JSONObject payload = json.getJSONObject("payload");
                        DesktopConnection.this.timingEvent("action:" + action);
                        if (action.equals("ack")) {
                            logger.debug("Receiving Ack: " + message.getText());
                            if (json.has("correlationId")) {
                                long correlationId = json.getLong("correlationId");
                                if (correlationId == DesktopConnection.this.authReqMsgId) {
                                    boolean authDone = payload.getBoolean("success");
                                    if (!authDone) {
                                        logger.debug("retry sendRequestAuthorization");
                                        try {
                                            DesktopConnection.this.sendRequestAuthorization();
                                        }
                                        catch (Exception authEx) {
                                            logger.error("Error sending auth request", (Throwable)authEx);
                                            listener.onError(authEx.getMessage());
                                        }
                                    }
                                } else {
                                    DesktopConnection.this.sendAckToAckFuture(correlationId, payload);
                                }
                            }
                        } else if (action.equals("external-authorization-response")) {
                            try {
                                DesktopConnection.this.processExternalAuthorizationResponse(payload);
                            }
                            catch (Exception authEx) {
                                logger.error("Error processing auth request", (Throwable)authEx);
                                listener.onError(authEx.getMessage());
                            }
                        } else if (action.equals("authorization-response")) {
                            DesktopConnection.this.authRequested = true;
                            boolean success = payload.getBoolean("success");
                            if (success) {
                                DesktopConnection.this.connected = true;
                                listener.onReady();
                                DesktopConnection.this.startEvent("Connected");
                            } else if (!DesktopConnection.this.disconnecting) {
                                String reason = payload.getString("reason");
                                try {
                                    listener.onError(reason);
                                    DesktopConnection.this.disconnect("Authorization request to Runtime is denied");
                                }
                                catch (Exception ex) {
                                    logger.error("Error processing auth response");
                                }
                            }
                        } else if (action.equals("process-message")) {
                            String sourceUuid = payload.getString("sourceUuid");
                            String topic = payload.getString("topic");
                            DesktopConnection.this.busInstance.dispatchMessageToCallbacks(sourceUuid, topic, payload.get("message"));
                            if ("utils-ready".equals(topic)) {
                                DesktopConnection.this.startEvent("AdminReady");
                            }
                        } else if (action.equals("process-notification-event")) {
                            DesktopConnection.this.processNotificationEvent(payload);
                        } else if (action.equals("process-desktop-event")) {
                            DesktopConnection.this.dispatchDesktopEvent(payload);
                        } else if (action.equals("subscriber-added")) {
                            DesktopConnection.this.busInstance.dispatchToSubscribeListeners(payload.getString("uuid"), payload.getString("topic"));
                        } else if (action.equals("subscriber-removed")) {
                            DesktopConnection.this.busInstance.dispatchToUnsubscribeListeners(payload.getString("uuid"), payload.getString("topic"));
                        } else if (!action.equals("process-external-app-action")) {
                            if (action.equals("ping")) {
                                long pingId = payload.getLong("pingId");
                                DesktopConnection.this.respondToPing(pingId);
                            } else if (action.equals("process-external-message")) {
                                DesktopConnection.this.processExternalMessage(payload);
                            } else if (action.equals("app-connected")) {
                                DesktopConnection.this.processWindowConnected(payload);
                            } else if (action.equals("app-loaded")) {
                                DesktopConnection.this.processWindowLoaded(payload);
                            } else if (action.equals("process-channel-connection")) {
                                DesktopConnection.this.processChannelConnection(payload);
                            } else if (action.equals("process-channel-message")) {
                                DesktopConnection.this.processChannelMessage(payload);
                            } else if (action.equals("send-channel-result")) {
                                DesktopConnection.this.processChannelMessage(payload);
                            } else {
                                logger.error("action \"{}\" not handled in Java Adapter", (Object)action);
                            }
                        }
                    }
                    catch (JSONException e) {
                        logger.error("Error processing message from Runtime", (Throwable)e);
                        listener.onError(e.getMessage());
                    }
                });
            }

            @Override
            public void onClose(int statusCode, String reason) {
                logger.debug("onClose");
                DesktopConnection.this.connected = false;
                DesktopConnection.this.opened = false;
                DesktopConnection.this.cancelConnectWaitTimer();
                listener.onClose(reason);
                DesktopConnection.this.busInstance.reset();
                DesktopConnection.this.disconnecting = false;
            }

            @Override
            public void onError(Throwable cause) {
                logger.debug(String.format("onError %s", cause.toString()));
                DesktopConnection.this.cancelConnectWaitTimer();
                listener.onError(cause.toString());
            }
        });
        this.startConnectWaitTimer(new TimerTask(){

            @Override
            public void run() {
                if (DesktopConnection.this.websocket.isConnected()) {
                    logger.debug("connectToDesktop-timer-stopped connected");
                    DesktopConnection.this.timer.cancel();
                } else if (DesktopConnection.this.authRequested) {
                    logger.debug("connectToDesktop-timer-stopped auth received");
                    DesktopConnection.this.timer.cancel();
                } else if (!DesktopConnection.this.opened) {
                    try {
                        logger.debug("Trying to connect to Runtime");
                        DesktopConnection.this.websocket.connect();
                    }
                    catch (WebSocketException e) {
                        logger.error("Failed to connect to Runtime", (Throwable)e);
                    }
                }
                if (DesktopConnection.this.checkConnectTimeout()) {
                    DesktopConnection.this.cancelConnectWaitTimer();
                    listener.onError("Connection timed out");
                }
            }
        });
    }

    private void startConnectWaitTimer(TimerTask timerTask) {
        this.cancelConnectWaitTimer();
        this.waitStartTime = System.currentTimeMillis();
        this.timer = new Timer(String.format("ConnectWaitTimer-%s", this.uuid));
        logger.debug("connectToDesktop-timer-start " + this.uuid);
        this.timer.schedule(timerTask, 0L, 100L);
    }

    private void cancelConnectWaitTimer() {
        if (this.timer != null) {
            logger.debug("connectToDesktop-timer-stopped " + this.uuid);
            this.timer.cancel();
        }
    }

    private boolean checkConnectTimeout() {
        int secs = (int)((System.currentTimeMillis() - this.waitStartTime) / 1000L);
        if (secs > this.timeout) {
            logger.debug("checkConnectTimeout true " + this.uuid);
            return true;
        }
        return false;
    }

    private void sendAckToAckFuture(long correlationId, JSONObject payload) {
        CallBackSourcePair lsp = this.callbacks.remove(correlationId);
        if (lsp != null) {
            Object source = lsp.getSource();
            lsp.getFuture().complete(new Ack(payload, source));
        } else {
            logger.error("ackFuture missing, correlationId: {}", (Object)correlationId);
        }
    }

    private void processExternalAuthorizationResponse(JSONObject payload) throws JSONException, IOException, WebSocketException {
        if (this.authorizationType.equals("file-token")) {
            String token = payload.getString("token");
            String file = payload.getString("file");
            if (token != null && file != null && file.length() > 0 && token.length() > 0) {
                FileWriter writer = new FileWriter(file);
                writer.write(token);
                writer.close();
            }
        }
        this.sendFinalAuthorizationRequest(this.authorizationType);
    }

    private void sendFinalAuthorizationRequest(String type) throws JSONException, WebSocketException {
        this.disconnecting = false;
        JSONObject json = new JSONObject();
        json.put("action", (Object)"request-authorization");
        JSONObject payload = new JSONObject();
        payload.put("uuid", (Object)this.uuid);
        payload.put("type", (Object)type);
        if (this.activeConfiguration.isNonPersistent()) {
            payload.put("nonPersistent", true);
        }
        json.put("payload", (Object)payload);
        String msg = json.toString();
        if (this.listener != null) {
            this.listener.onOutgoingMessage(msg);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Sending: " + msg);
        }
        this.websocket.send(msg);
    }

    private void processNotificationEvent(JSONObject payload) {
        Integer notificationId;
        if (payload != null && (notificationId = this.getNestedJSONInteger(payload, "payload.notificationId")) != null) {
            try {
                String type;
                CallBackSourcePair lsp = this.notificationListenerMap.get(notificationId);
                if (lsp != null && ((type = payload.getString("type")) == "close" || type == "error" || type == "dismiss")) {
                    this.notificationListenerMap.remove(notificationId);
                }
            }
            catch (Exception e) {
                logger.error("Error processing notification event", (Throwable)e);
            }
        }
    }

    private Integer getNestedJSONInteger(JSONObject json, String expression) {
        Integer result = null;
        StringTokenizer tokenizer = new StringTokenizer(expression, ".");
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        JSONObject nested = json;
        try {
            for (int i = 0; i < list.size() - 1; ++i) {
                if (!nested.has((String)list.get(i))) {
                    nested = null;
                    break;
                }
                nested = nested.getJSONObject((String)list.get(i));
            }
            if (nested != null) {
                result = nested.getInt((String)list.get(list.size() - 1));
            }
        }
        catch (Exception e) {
            logger.error("Error reading integer from JSON", (Throwable)e);
        }
        return result;
    }

    private List<CallBackSourcePair> getEventCallbackList(JSONObject subscriptionObject) {
        List<CallBackSourcePair> list = null;
        try {
            String topic = subscriptionObject.getString("topic");
            String type = this.getFullEventType(topic, subscriptionObject.getString("type"));
            String uuid = JsonUtils.getStringValue(subscriptionObject, "uuid", null);
            String name = null;
            if (subscriptionObject.has("name")) {
                name = subscriptionObject.getString("name");
            }
            list = this.getEventCallbackList(topic, type, uuid, name);
        }
        catch (Exception e) {
            logger.error("Error getting event callback list", (Throwable)e);
        }
        return list;
    }

    private List<CallBackSourcePair> getEventCallbackList(String topic, String type, String uuid, String name) {
        List<CallBackSourcePair> callbacks = null;
        if (topic != null && type != null) {
            if (topic.equals("application")) {
                if (uuid != null) {
                    Map<String, List<CallBackSourcePair>> matchedType;
                    Map<String, Map<String, List<CallBackSourcePair>>> matchedTopic = this.applicationEventCallbackMap.get(topic);
                    if (matchedTopic == null) {
                        matchedTopic = new ConcurrentHashMap<String, Map<String, List<CallBackSourcePair>>>();
                        this.applicationEventCallbackMap.put(topic, matchedTopic);
                    }
                    if ((matchedType = matchedTopic.get(type)) == null) {
                        matchedType = new ConcurrentHashMap<String, List<CallBackSourcePair>>();
                        matchedTopic.put(type, matchedType);
                    }
                    if ((callbacks = matchedType.get(uuid)) == null) {
                        callbacks = new CopyOnWriteArrayList<CallBackSourcePair>();
                        matchedType.put(uuid, callbacks);
                    }
                }
            } else if (topic.equals("channel")) {
                Map<String, List<CallBackSourcePair>> matchedTopic = this.channelEventCallbackMap.get(topic);
                if (matchedTopic == null) {
                    matchedTopic = new ConcurrentHashMap<String, List<CallBackSourcePair>>();
                    this.channelEventCallbackMap.put(topic, matchedTopic);
                }
                if ((callbacks = matchedTopic.get(type)) == null) {
                    callbacks = new CopyOnWriteArrayList<CallBackSourcePair>();
                    matchedTopic.put(type, callbacks);
                }
            } else if (topic.equals("system")) {
                Map<String, List<CallBackSourcePair>> matchedTopic = this.systemEventCallbackMap.get(topic);
                if (matchedTopic == null) {
                    matchedTopic = new ConcurrentHashMap<String, List<CallBackSourcePair>>();
                    this.systemEventCallbackMap.put(topic, matchedTopic);
                }
                if ((callbacks = matchedTopic.get(type)) == null) {
                    callbacks = new CopyOnWriteArrayList<CallBackSourcePair>();
                    matchedTopic.put(type, callbacks);
                }
            } else if (topic.equals("window") || topic.equals("view")) {
                if (uuid != null && name != null) {
                    Map<String, List<CallBackSourcePair>> matchedUuid;
                    Map<String, Map<String, List<CallBackSourcePair>>> matchedType;
                    Map<String, Map<String, Map<String, List<CallBackSourcePair>>>> matchedTopic = this.webContentEventCallbackMap.get(topic);
                    if (matchedTopic == null) {
                        matchedTopic = new ConcurrentHashMap<String, Map<String, Map<String, List<CallBackSourcePair>>>>();
                        this.webContentEventCallbackMap.put(topic, matchedTopic);
                    }
                    if ((matchedType = matchedTopic.get(type)) == null) {
                        matchedType = new ConcurrentHashMap<String, Map<String, List<CallBackSourcePair>>>();
                        matchedTopic.put(type, matchedType);
                    }
                    if ((matchedUuid = matchedType.get(uuid)) == null) {
                        matchedUuid = new ConcurrentHashMap<String, List<CallBackSourcePair>>();
                        matchedType.put(uuid, matchedUuid);
                    }
                    if ((callbacks = matchedUuid.get(name)) == null) {
                        callbacks = new CopyOnWriteArrayList<CallBackSourcePair>();
                        matchedUuid.put(name, callbacks);
                    }
                }
            } else {
                callbacks = null;
            }
        }
        return callbacks;
    }

    private String getFullEventType(String topic, String type) {
        String fullType = topic.equals("application") ? (type.indexOf("application-") == -1 ? "application-" + type : type) : (topic.equals("system") ? type : (topic.equals("window") ? (type.indexOf("window-") == -1 ? "window-" + type : type) : type));
        return fullType;
    }

    public CompletionStage<Ack> addEventCallbackAsync(JSONObject subscriptionObject, EventListener listener, Object source) {
        CompletableFuture<Ack> ackFuture;
        List<CallBackSourcePair> callbacks = this.getEventCallbackList(subscriptionObject);
        if (callbacks != null) {
            if (callbacks.size() == 0) {
                String topic = subscriptionObject.getString("topic");
                String type = subscriptionObject.getString("type");
                if (topic.equals("window") && type.equals("app-connected")) {
                    JSONObject notifyConnected = new JSONObject();
                    notifyConnected.put("targetUuid", (Object)subscriptionObject.getString("uuid"));
                    notifyConnected.put("name", (Object)subscriptionObject.getString("name"));
                    ackFuture = this.sendActionAsync("notify-on-app-connected", notifyConnected, source);
                } else if (topic.equals("window") && type.equals("app-loaded")) {
                    JSONObject notifyConnected = new JSONObject();
                    notifyConnected.put("targetUuid", (Object)subscriptionObject.getString("uuid"));
                    notifyConnected.put("name", (Object)subscriptionObject.getString("name"));
                    ackFuture = this.sendActionAsync("notify-on-content-loaded", notifyConnected, source);
                } else {
                    ackFuture = this.sendActionAsync("subscribe-to-desktop-event", subscriptionObject, source);
                }
            } else {
                JSONObject payload = new JSONObject();
                payload.put("success", true);
                Ack ack = new Ack(payload, source);
                ackFuture = CompletableFuture.completedFuture(ack);
            }
            callbacks.add(new CallBackSourcePair(listener, subscriptionObject.getString("type"), source));
        } else {
            JSONObject payload = new JSONObject();
            payload.put("success", false);
            payload.put("reason", (Object)"invalid event topic");
            Ack nack = new Ack(payload, source);
            ackFuture = CompletableFuture.completedFuture(nack);
        }
        return ackFuture;
    }

    public void addEventCallback(JSONObject subscriptionObject, EventListener listener, AckListener callback, Object source) {
        this.addEventCallbackAsync(subscriptionObject, listener, source).thenAccept(ack -> {
            if (ack.isSuccessful()) {
                DesktopUtils.successAck(callback, ack);
            } else {
                DesktopUtils.errorAck(callback, ack);
            }
        });
    }

    public CompletionStage<Ack> removeEventCallbackAsync(JSONObject subscriptionObject, EventListener listener, Object source) {
        JSONObject payload;
        CompletableFuture<Ack> ackFuture = null;
        List<CallBackSourcePair> callbacks = this.getEventCallbackList(subscriptionObject);
        if (callbacks != null && this.removeFromListenerSourcePairList(callbacks, listener, source)) {
            if (callbacks.size() == 0) {
                String topic = subscriptionObject.getString("topic");
                String type = subscriptionObject.getString("type");
                if (!(topic.equals("window") && type.equals("app-connected") || topic.equals("window") && type.equals("app-loaded"))) {
                    ackFuture = this.sendActionAsync("unsubscribe-to-desktop-event", subscriptionObject, source);
                }
            }
            if (ackFuture == null) {
                payload = new JSONObject();
                payload.put("success", true);
                Ack ack = new Ack(payload, source);
                ackFuture = CompletableFuture.completedFuture(ack);
            }
        }
        if (ackFuture == null) {
            payload = new JSONObject();
            payload.put("success", false);
            payload.put("reason", (Object)"unable to remove specified event listener");
            Ack nack = new Ack(payload, source);
            ackFuture = CompletableFuture.completedFuture(nack);
        }
        return ackFuture;
    }

    public void removeEventCallback(JSONObject subscriptionObject, EventListener listener, AckListener callback, Object source) {
        this.removeEventCallbackAsync(subscriptionObject, listener, source).thenAccept(ack -> {
            if (ack.isSuccessful()) {
                DesktopUtils.successAck(callback, ack);
            } else {
                DesktopUtils.errorAck(callback, ack);
            }
        });
    }

    private boolean removeFromListenerSourcePairList(List<CallBackSourcePair> list, EventListener listener, Object source) {
        boolean removed = false;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                CallBackSourcePair lsp = list.get(i);
                if (lsp.getEventListener() != listener || lsp.getSource() != source) continue;
                list.remove(i);
                removed = true;
                break;
            }
        }
        return removed;
    }

    private void dispatchDesktopEvent(JSONObject payload) {
        List<CallBackSourcePair> callbacks = this.getEventCallbackList(payload);
        if (callbacks != null) {
            for (CallBackSourcePair lsp : callbacks) {
                lsp.getEventListener().eventReceived(new ActionEvent(lsp.getType(), payload, lsp.getSource()));
            }
        }
    }

    protected void respondToPing(long pingId) {
        JSONObject payload = new JSONObject();
        try {
            payload.put("correlationId", pingId);
            this.sendAction("pong", payload);
        }
        catch (Exception e) {
            logger.error("Error responding to ping", (Throwable)e);
        }
    }

    public void addExternalMessageHandler(ExternalMessageListener listener, Object source) {
        this.externalMessageHandlers.add(new ExternalMessageListenerSourcePair(listener, source));
    }

    private void processExternalMessage(JSONObject payload) {
        ExternalMessageResultHandlerFactory messageHandlerFactory = new ExternalMessageResultHandlerFactory(this.uuid, this, payload);
        for (ExternalMessageListenerSourcePair pair : this.externalMessageHandlers) {
            pair.handler.process(messageHandlerFactory.makeResultHandler(), payload);
        }
        messageHandlerFactory.allDispatched();
    }

    private void processWindowConnected(JSONObject payload) {
        String uuid = payload.getString("uuid");
        String appUuid = payload.getString("appUuid");
        String name = payload.getString("name");
        String topic = "window";
        String type = this.getFullEventType(topic, "app-connected");
        List<CallBackSourcePair> list = this.getEventCallbackList(topic, type, appUuid, name);
        if (list != null) {
            for (CallBackSourcePair pair : list) {
                pair.getEventListener().eventReceived(new ActionEvent(pair.getType(), payload, pair.getSource()));
            }
        }
    }

    private void processWindowLoaded(JSONObject payload) {
        String uuid = payload.getString("uuid");
        String appUuid = payload.getString("appUuid");
        String name = payload.getString("name");
        String topic = "window";
        String type = this.getFullEventType(topic, "app-loaded");
        List<CallBackSourcePair> list = this.getEventCallbackList(topic, type, appUuid, name);
        if (list != null) {
            for (CallBackSourcePair pair : list) {
                pair.getEventListener().eventReceived(new ActionEvent(pair.getType(), payload, pair.getSource()));
            }
        }
    }

    private void processChannelConnection(JSONObject payload) {
        JSONObject providerIdentity = payload.getJSONObject("providerIdentity");
        String channelName = providerIdentity.getString("channelName");
        Channel channel = this.getChannel(channelName);
        if (channel != null && channel.hasProvider()) {
            JSONObject ackToSender = payload.getJSONObject("ackToSender");
            String action = ackToSender.getString("action");
            JSONObject ackToSenderPayload = ackToSender.getJSONObject("payload");
            try {
                channel.processConnection(payload);
            }
            catch (Exception ex) {
                ackToSenderPayload.put("success", false);
                ackToSenderPayload.put("reason", (Object)ex.getMessage());
            }
            try {
                logger.info("channel client connected, action: {}, ackToSenderPayload: {}", (Object)action, (Object)ackToSenderPayload.toString());
                this.sendAction(action, ackToSenderPayload);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            catch (DesktopException e) {
                e.printStackTrace();
            }
        }
    }

    private void processChannelMessage(JSONObject payload) {
        logger.info("processChannelMessage, payload: {}", (Object)payload);
        JSONObject senderIdentity = payload.getJSONObject("senderIdentity");
        EndpointIdentity providerIdentity = new EndpointIdentity(payload.getJSONObject("providerIdentity"));
        JSONObject ackToSender = payload.getJSONObject("ackToSender");
        String channelName = providerIdentity.getChannelName();
        String action = payload.getString("action");
        EndpointIdentity targetIdentity = new EndpointIdentity(payload.getJSONObject("intendedTargetIdentity"));
        Channel channel = this.getChannel(channelName);
        if (channel != null) {
            Object actionPayload = payload.opt("payload");
            JSONObject ackToSenderPayload = ackToSender.getJSONObject("payload");
            JSONObject resultPayload = ackToSenderPayload.getJSONObject("payload");
            Object actionResult = channel.invokeAction(targetIdentity, action, actionPayload, senderIdentity);
            resultPayload.put("result", actionResult);
            try {
                this.sendAction(ackToSender.getString("action"), ackToSenderPayload);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            catch (DesktopException e) {
                e.printStackTrace();
            }
        } else {
            logger.debug("processChannelMessage[{}::{}], no such channel: {}", new Object[]{channelName, action, payload});
        }
    }

    public void setAdditionalRuntimeArguments(String additionalRuntimeArguments) {
        this.additionalRuntimeArguments = additionalRuntimeArguments;
    }

    public void setAdditionalRvmArguments(String additionalRvmArguments) {
        this.additionalRvmArguments = additionalRvmArguments;
    }

    public void setRuntimeSecurityRealm(String runtimeSecurityRealm) {
        this.runtimeSecurityRealm = runtimeSecurityRealm;
    }

    public void setRdmUrl(String url) {
        this.rdmUrl = url;
    }

    public void setDevToolsPort(int port) {
        this.devtoolsPort = port;
    }

    public void setLogLevel(boolean enabled) {
    }

    private static String getProcessId(String fallback) {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return fallback;
        }
        try {
            return Long.toString(Long.parseLong(jvmName.substring(0, index)));
        }
        catch (NumberFormatException numberFormatException) {
            return fallback;
        }
    }

    public Channel getChannel(String name) {
        return this.channels.computeIfAbsent(name, key -> new Channel(name, this));
    }

    public Interop getInterop() {
        if (this.interop == null) {
            this.interop = new Interop(this);
        }
        return this.interop;
    }

    public SnapshotSource getSnapshotSource() {
        if (this.snapshotSource == null) {
            this.snapshotSource = new SnapshotSource(this);
        }
        return this.snapshotSource;
    }

    public String getUuid() {
        return this.uuid;
    }

    public <T> CompletableFuture<T> launchManifest(String manifestUrl, Class<T> type, RVMOptions options) throws IllegalArgumentException {
        if (!(type.getSimpleName().equals("Application") || type.getSimpleName().equals("Platform") || type.getSimpleName().equals("JSONOBject"))) {
            throw new IllegalArgumentException("Class must be either an Application, Platform, or JSONObject");
        }
        JSONObject payload = new JSONObject();
        payload.put("manifestUrl", (Object)manifestUrl);
        payload.put("opts", (Object)options);
        return this.sendActionAsync("launch-manifest", payload, DesktopConnection.class).thenApply(ack -> {
            if (type.getClass().getSimpleName().equals("JSONObject")) {
                return ack.getJsonObject();
            }
            if (type.getSimpleName().equals("Application")) {
                ApplicationOptions appOptions = new ApplicationOptions(ack.getJsonObject().getJSONObject("manifest").getJSONObject("startup_app"));
                return Application.wrap(appOptions.getUUID(), this);
            }
            PlatformOptions platformOptions = new PlatformOptions(ack.getJsonObject().getJSONObject("manifest").getJSONObject("platform"));
            return Platform.start(this, platformOptions);
        });
    }

    private static class ExternalMessageListenerSourcePair {
        private ExternalMessageListener handler;
        private Object source;

        public ExternalMessageListenerSourcePair(ExternalMessageListener handler, Object source) {
            this.handler = handler;
            this.source = source;
        }
    }

    private static class CallBackSourcePair {
        private EventListener eventListener;
        private Object source;
        private String type;
        private CompletableFuture<Ack> future;

        CallBackSourcePair(CompletableFuture<Ack> future, Object source) {
            this.future = future;
            this.source = source;
        }

        CallBackSourcePair(EventListener listener, String eventType, Object source) {
            this.eventListener = listener;
            this.type = eventType;
            this.source = source;
        }

        Object getSource() {
            return this.source;
        }

        CompletableFuture<Ack> getFuture() {
            return this.future;
        }

        EventListener getEventListener() {
            return this.eventListener;
        }

        String getType() {
            return this.type;
        }
    }
}

