/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop;

import com.openfin.desktop.Ack;
import com.openfin.desktop.DesktopConnection;
import com.openfin.desktop.EventListener;
import com.openfin.desktop.FindInPageOptions;
import com.openfin.desktop.Identity;
import com.openfin.desktop.PrintOptions;
import com.openfin.desktop.PrinterInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class WebContent {
    protected DesktopConnection connection;
    protected Identity identity;

    protected WebContent(Identity identity, DesktopConnection connection) {
        this.identity = identity;
        this.connection = connection;
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public String getUuid() {
        return this.identity.getUuid();
    }

    public String getName() {
        return this.identity.getName();
    }

    protected abstract String getEventTopicName();

    public CompletionStage<Ack> addEventListener(String type, EventListener listener) {
        JSONObject eventListenerPayload = this.identity.getJsonCopy();
        eventListenerPayload.put("topic", (Object)this.getEventTopicName());
        eventListenerPayload.put("type", (Object)type);
        return this.connection.addEventCallbackAsync(eventListenerPayload, listener, this);
    }

    public CompletionStage<Ack> removeEventListener(String type, EventListener listener) {
        JSONObject eventListenerPayload = this.identity.getJsonCopy();
        eventListenerPayload.put("topic", (Object)this.getEventTopicName());
        eventListenerPayload.put("type", (Object)type);
        return this.connection.addEventCallbackAsync(eventListenerPayload, listener, this);
    }

    public DesktopConnection getConnection() {
        return this.connection;
    }

    public CompletionStage<JSONObject> executeJavaScript(String code) {
        JSONObject payload = this.identity.getJsonCopy();
        payload.put("code", (Object)code);
        return this.connection.sendActionAsync("execute-javascript-in-window", payload, this).thenApply(ack -> {
            if (ack.isSuccessful()) {
                return ack.getJsonObject().optJSONObject("data");
            }
            throw new RuntimeException("error executeJavaScript, reason: " + ack.getReason());
        });
    }

    public CompletionStage<Double> getZoomLevel() {
        return this.connection.sendActionAsync("get-zoom-level", this.identity.getJson(), this).thenApply(ack -> {
            if (ack.isSuccessful()) {
                return ack.getJsonObject().optDouble("data", 0.0);
            }
            throw new RuntimeException("error getZoomLevel, reason: " + ack.getReason());
        });
    }

    public CompletionStage<Void> setZoomLevel(double zoom) {
        JSONObject payload = this.identity.getJsonCopy();
        payload.put("level", zoom);
        return this.connection.sendActionAsync("set-zoom-level", payload, this).thenAccept(ack -> {
            if (!ack.isSuccessful()) {
                throw new RuntimeException("error setZoomLevel, reason: " + ack.getReason());
            }
        });
    }

    public CompletionStage<Void> navigate(String url) {
        JSONObject payload = this.identity.getJsonCopy();
        payload.put("url", (Object)url);
        return this.connection.sendActionAsync("navigate-window", payload, this).thenAccept(ack -> {
            if (!ack.isSuccessful()) {
                throw new RuntimeException("error navigate, reason: " + ack.getReason());
            }
        });
    }

    public CompletionStage<Void> navigateBack() {
        return this.connection.sendActionAsync("navigate-window-back", this.identity.getJson(), this).thenAccept(ack -> {
            if (!ack.isSuccessful()) {
                throw new RuntimeException("error navigateBack, reason: " + ack.getReason());
            }
        });
    }

    public CompletionStage<Void> navigateForward() {
        return this.connection.sendActionAsync("navigate-window-forward", this.identity.getJson(), this).thenAccept(ack -> {
            if (!ack.isSuccessful()) {
                throw new RuntimeException("error navigateForward, reason: " + ack.getReason());
            }
        });
    }

    public CompletionStage<Void> stopNavigation() {
        return this.connection.sendActionAsync("stop-window-navigation", this.identity.getJson(), this).thenAccept(ack -> {
            if (!ack.isSuccessful()) {
                throw new RuntimeException("error stopNavigation, reason: " + ack.getReason());
            }
        });
    }

    public CompletionStage<Void> reloadAsync(boolean ignoreCache) {
        JSONObject payload = this.identity.getJsonCopy();
        payload.put("ignoreCache", ignoreCache);
        return this.connection.sendActionAsync("reload-window", payload, this).thenAccept(ack -> {
            if (!ack.isSuccessful()) {
                throw new RuntimeException("error reloadAsync, reason: " + ack.getReason());
            }
        });
    }

    public CompletionStage<Void> printAsync(PrintOptions opts) {
        JSONObject payload = this.identity.getJsonCopy();
        if (opts != null) {
            payload.put("options", (Object)opts.getJson());
        }
        return this.connection.sendActionAsync("print", payload, this).thenAccept(ack -> {
            if (!ack.isSuccessful()) {
                throw new RuntimeException("error printAsync, reason: " + ack.getReason());
            }
        });
    }

    public CompletionStage<Void> findInPage(String searchTerm, FindInPageOptions opts) {
        JSONObject payload = this.identity.getJsonCopy();
        payload.put("searchTerm", (Object)searchTerm);
        if (opts != null) {
            payload.put("options", (Object)opts.getJson());
        }
        return this.connection.sendActionAsync("find-in-page", payload, this).thenAccept(ack -> {
            if (!ack.isSuccessful()) {
                throw new RuntimeException("error findInPage, reason: " + ack.getReason());
            }
        });
    }

    public CompletionStage<Void> stopFindInPage(String action) {
        JSONObject payload = this.identity.getJsonCopy();
        payload.put("action", (Object)action);
        return this.connection.sendActionAsync("stop-find-in-page", payload, this).thenAccept(ack -> {
            if (!ack.isSuccessful()) {
                throw new RuntimeException("error stopFindInPage, reason: " + ack.getReason());
            }
        });
    }

    public CompletionStage<List<PrinterInfo>> getPrinters() {
        return this.connection.sendActionAsync("get-printers", this.identity.getJson(), this).thenApply(ack -> {
            if (ack.isSuccessful()) {
                JSONArray printersJson = ack.getJsonObject().getJSONArray("data");
                int printerCnt = printersJson.length();
                ArrayList<PrinterInfo> printers = new ArrayList<PrinterInfo>(printerCnt);
                for (int i = 0; i < printerCnt; ++i) {
                    printers.add(new PrinterInfo(printersJson.getJSONObject(i)));
                }
                return printers;
            }
            throw new RuntimeException("error getPrinters, reason: " + ack.getReason());
        });
    }

    public CompletionStage<Void> focusAsync() {
        JSONObject payload = this.identity.getJsonCopy();
        payload.put("emitSynthFocused", true);
        return this.connection.sendActionAsync("focus-window", payload, this).thenAccept(ack -> {
            if (!ack.isSuccessful()) {
                throw new RuntimeException("error focusAsync, reason: " + ack.getReason());
            }
        });
    }

    public CompletionStage<Void> showDeveloperTools() {
        return this.connection.sendActionAsync("show-developer-tools", this.identity.getJson(), this).thenAccept(ack -> {
            if (!ack.isSuccessful()) {
                throw new RuntimeException("error showDeveloperTools, reason: " + ack.getReason());
            }
        });
    }
}

