/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.channel;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import com.openfin.desktop.channel.Channel;
import com.openfin.desktop.channel.ChannelAction;
import com.openfin.desktop.channel.ChannelBase;
import com.openfin.desktop.channel.ChannelListener;
import com.openfin.desktop.channel.ConnectionEvent;
import com.openfin.desktop.channel.EndpointIdentity;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

public class ChannelClient
extends ChannelBase {
    private CopyOnWriteArrayList<ChannelListener> channelListeners = new CopyOnWriteArrayList();

    ChannelClient(Channel messageChannelFactory, EndpointIdentity endpointIdentity) {
        super(messageChannelFactory, endpointIdentity);
    }

    public void dispatch(String action, JSONObject actionPayload, AckListener ackListener) {
        super.dispatch(this.endpointIdentity.toJSON(), action, actionPayload, ackListener);
    }

    public CompletableFuture<Ack> dispatchAsync(String action, Object actionPayload) {
        return super.dispatchAsync(this.endpointIdentity.toJSON(), action, actionPayload);
    }

    @Override
    public boolean register(String action, ChannelAction listener) {
        return super.register(action, listener);
    }

    public void disconnect(AckListener ackListener) {
        this.channel.disconnect(this, ackListener);
    }

    public boolean addChannelListener(ChannelListener listener) {
        return this.channelListeners.add(listener);
    }

    public boolean removeChannelListener(ChannelListener listener) {
        return this.channelListeners.remove(listener);
    }

    void fireChannelConnectEvent(ConnectionEvent event) {
        for (ChannelListener listener : this.channelListeners) {
            listener.onChannelConnect(event);
        }
    }

    void fireChannelDisconnectEvent(ConnectionEvent event) {
        for (ChannelListener listener : this.channelListeners) {
            listener.onChannelDisconnect(event);
        }
    }
}

