/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.net;

import com.openfin.desktop.OpenFinThreadPool;
import java.util.concurrent.Executor;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.common.scopes.SimpleContainerScope;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebSocketClientFactory {
    private static Logger logger = LoggerFactory.getLogger((String)WebSocketClientFactory.class.getName());
    private static WebSocketClient client;

    WebSocketClientFactory() {
    }

    static synchronized WebSocketClient getWebSocketClient() {
        if (client == null) {
            logger.debug("Creating WebSocketClient");
            String strJettyThreads = System.getProperty("com.openfin.desktop.threads.jetty");
            if (strJettyThreads != null) {
                int jettyThreads = Integer.parseInt(strJettyThreads);
                SimpleContainerScope scope = new SimpleContainerScope(new WebSocketPolicy(WebSocketBehavior.CLIENT), null, (Executor)new OpenFinThreadPool("OpenFinJetty", jettyThreads), null);
                HttpClient httpClient = new HttpClient((HttpClientTransport)new HttpClientTransportOverHTTP(Math.max(1, Math.min(ProcessorUtils.availableProcessors() / 2, jettyThreads - 1))), null);
                httpClient.setExecutor(scope.getExecutor());
                try {
                    httpClient.start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                client = new WebSocketClient((WebSocketContainerScope)scope, null, null, httpClient);
            } else {
                client = new WebSocketClient();
            }
            try {
                logger.debug("Starting WebSocketClient");
                client.start();
            }
            catch (Exception e) {
                logger.error("Error creating WebSocketClient", (Throwable)e);
            }
        }
        return client;
    }

    static synchronized void stopWebSocketClient() {
        if (client != null) {
            try {
                if (client.getOpenSessions().isEmpty()) {
                    logger.debug("No live sessions.  closing");
                    client.stop();
                    client = null;
                }
            }
            catch (Exception e) {
                logger.error("Error stopping WebSocketClient", (Throwable)e);
            }
        }
    }
}

