/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.net;

import com.openfin.desktop.net.WebSocketClientFactory;
import com.openfin.desktop.net.WebSocketEventHandler;
import com.openfin.desktop.net.WebSocketException;
import com.openfin.desktop.net.WebSocketMessage;
import java.net.URI;
import java.util.concurrent.Future;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket(maxTextMessageSize=65536)
public class WebSocketConnection {
    private static Logger logger = LoggerFactory.getLogger((String)WebSocketConnection.class.getName());
    private URI url = null;
    private WebSocketEventHandler eventHandler = null;
    private Session session;
    private Future<Session> connectFuture;

    public WebSocketConnection(URI url) throws WebSocketException {
        this.url = url;
    }

    public void setEventHandler(WebSocketEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public WebSocketEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public boolean isConnected() {
        return this.session != null;
    }

    public void connect() throws WebSocketException {
        try {
            if (this.session != null) {
                throw new WebSocketException("already connected");
            }
            if (this.connectFuture != null && !this.connectFuture.isDone()) {
                logger.debug("Waiting to be connected");
            } else {
                ClientUpgradeRequest request = new ClientUpgradeRequest();
                this.connectFuture = WebSocketClientFactory.getWebSocketClient().connect((Object)this, this.url, request);
            }
        }
        catch (Exception ex) {
            throw new WebSocketException("error while connecting: " + ex.getMessage(), ex);
        }
    }

    public synchronized void send(String data) throws WebSocketException {
        if (this.session == null) {
            throw new WebSocketException("error while sending text data: not connected");
        }
        try {
            this.session.getRemote().sendString(data);
        }
        catch (Exception ioe) {
            throw new WebSocketException("error while sending text data: " + data, ioe);
        }
    }

    public void close() throws WebSocketException {
        this.close("Requested by OpenFin app");
    }

    public synchronized void close(String reason) throws WebSocketException {
        try {
            if (this.session != null) {
                logger.debug(String.format("close %s", reason));
                this.session.close(1000, reason);
            }
        }
        catch (Exception ex) {
            logger.error("Error closing session", (Throwable)ex);
        }
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        logger.debug(String.format("Connection closed: %d - %s", statusCode, reason));
        this.session = null;
        try {
            this.eventHandler.onClose(statusCode, reason);
        }
        catch (Exception ex) {
            logger.error("Error processing close event", (Throwable)ex);
        }
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        session.setIdleTimeout(0L);
        logger.debug(String.format("Connected: %s timeout: %d", session.getLocalAddress(), session.getIdleTimeout()));
        this.session = session;
        this.eventHandler.onOpen();
    }

    @OnWebSocketMessage
    public void onMessage(String msg) {
        this.eventHandler.onMessage(new WebSocketMessage(msg));
    }

    @OnWebSocketError
    public void onError(Throwable cause) {
        logger.error("onError", cause);
        try {
            this.eventHandler.onError(cause);
        }
        catch (Exception ex) {
            logger.error("Error processing error event", (Throwable)ex);
        }
    }

    public void setMaxMessageSize(int size) {
        this.session.getPolicy().setMaxTextMessageSize(size);
    }
}

