/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.platform;

import com.openfin.desktop.DesktopConnection;
import com.openfin.desktop.Identity;
import com.openfin.desktop.WebContent;
import com.openfin.desktop.Window;
import com.openfin.desktop.platform.PlatformViewOptions;
import java.util.concurrent.CompletableFuture;
import org.json.JSONObject;

public class PlatformView
extends WebContent {
    public PlatformView(Identity identity, DesktopConnection connection) {
        super(identity, connection);
    }

    public static PlatformView wrap(Identity identity, DesktopConnection desktopConnection) {
        return new PlatformView(identity, desktopConnection);
    }

    public CompletableFuture<Window> getCurrentWindow() {
        return this.connection.sendActionAsync("get-view-window", this.identity.getJsonCopy(), this).thenApply(ack -> {
            if (ack.isSuccessful()) {
                JSONObject windowIdentity = ack.getJsonObject().getJSONObject("data");
                return Window.wrap(windowIdentity.optString("uuid", null), windowIdentity.optString("name", null), this.connection);
            }
            throw new RuntimeException("unable to get current window of the view, reason: " + ack.getReason());
        });
    }

    public CompletableFuture<PlatformView> setBounds(int left, int top, int width, int height) {
        JSONObject bounds = new JSONObject();
        bounds.put("left", left);
        bounds.put("top", top);
        bounds.put("width", width);
        bounds.put("height", height);
        JSONObject payload = new JSONObject();
        payload.put("uuid", (Object)this.identity.getUuid());
        payload.put("name", (Object)this.identity.getName());
        payload.put("bounds", (Object)bounds);
        return this.connection.sendActionAsync("set-view-bounds", payload, this).thenApply(ack -> {
            if (ack.isSuccessful()) {
                return this;
            }
            throw new RuntimeException("unable to get current window of the view, reason: " + ack.getReason());
        });
    }

    public CompletableFuture<PlatformViewOptions> getOptions() {
        return this.connection.sendActionAsync("get-view-options", this.identity.getJsonCopy(), this).thenApply(ack -> new PlatformViewOptions(ack.getJsonObject().getJSONObject("data")));
    }

    @Override
    protected String getEventTopicName() {
        return "view";
    }
}

