/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop.snapshot;

import com.openfin.desktop.Ack;
import com.openfin.desktop.DesktopConnection;
import com.openfin.desktop.channel.ChannelClient;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotSourceClient {
    private static final Logger logger = LoggerFactory.getLogger((String)SnapshotSourceClient.class.getName());
    private final DesktopConnection desktopConnection;
    private final String uuid;
    private ChannelClient channelClient;

    public SnapshotSourceClient(DesktopConnection desktopConnection, String uuid) {
        this.desktopConnection = desktopConnection;
        this.uuid = uuid;
    }

    public CompletableFuture<JSONObject> getSnapshotAsync() {
        return this.channelClient.dispatchAsync("get-snapshot", JSONObject.NULL).thenApply(ack -> {
            if (ack.isSuccessful()) {
                return ((JSONObject)ack.getData()).getJSONObject("result");
            }
            throw new RuntimeException("error getting snapshot, reason: " + ack.getReason());
        });
    }

    public CompletableFuture<Ack> applySnapshotAsync(JSONObject snapshot) {
        return this.channelClient.dispatchAsync("apply-snapshot", snapshot);
    }

    CompletionStage<SnapshotSourceClient> initChannelClientAsync() {
        CompletableFuture<SnapshotSourceClient> future = new CompletableFuture<SnapshotSourceClient>();
        String cname = String.format("snapshot-source-provider-%s", this.uuid);
        logger.debug(String.format("initializing snapshot client %s", cname));
        CompletionStage<ChannelClient> stage = this.desktopConnection.getChannel(cname).connectAsync();
        stage.thenAccept(client -> {
            this.channelClient = client;
            future.complete(this);
        });
        return future;
    }
}

