/*
 * Decompiled with CFR 0.152.
 */
package com.openfin.desktop;

import com.openfin.desktop.Ack;
import com.openfin.desktop.AckListener;
import com.openfin.desktop.DesktopConnection;
import com.openfin.desktop.Window;
import com.openfin.desktop.WindowBounds;
import com.openfin.desktop.win32.ExternalWindowObserver;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WindowMember {
    private static final Logger logger = LoggerFactory.getLogger((String)WindowMember.class.getName());
    private Window window;
    private boolean isDocked;
    private boolean isSnapped;
    private WindowBounds bounds;
    private WindowMember anchor;
    private List<WindowMember> dockedChildren;
    private AckListener ackListener;
    private ExternalWindowObserver externalWindowObserver;
    private DesktopConnection desktopConnection;

    WindowMember(Window window, DesktopConnection desktopConnection) {
        this.window = window;
        this.desktopConnection = desktopConnection;
        this.isDocked = false;
        this.isSnapped = false;
        this.dockedChildren = new ArrayList<WindowMember>();
        this.ackListener = new AckListener(){

            public void onSuccess(Ack ack) {
                if (!ack.isSuccessful()) {
                    logger.error(String.format("notSuccessful %s", ack.getJsonObject().toString()));
                }
            }

            public void onError(Ack ack) {
                logger.error(String.format("onError %s", ack.getJsonObject().toString()));
            }
        };
    }

    static String getMemberKey(String appUuid, String windowName) {
        return String.format("%s:%s", appUuid, windowName);
    }

    static String getMemberKey(Window window) {
        return WindowMember.getMemberKey(window.getUuid(), window.getName());
    }

    public String getKey() {
        return WindowMember.getMemberKey(this.window);
    }

    public Window getWindow() {
        return this.window;
    }

    public boolean isDocked() {
        return this.isDocked;
    }

    public void setDocked(boolean docked) {
        this.isDocked = docked;
        try {
            JSONObject message = new JSONObject();
            message.put("applicationUuid", (Object)this.window.getUuid());
            message.put("windowName", (Object)this.window.getName());
            String topic = docked ? "window-docked" : "window-undocked";
            this.desktopConnection.getInterApplicationBus().publish(topic, (Object)message, this.ackListener);
        }
        catch (Exception ex) {
            logger.error(String.format("Error publishing docking status %s", this.getKey()), (Throwable)ex);
        }
    }

    public boolean isSnapped() {
        return this.isSnapped;
    }

    public void setSnapped(boolean snapped) {
        this.isSnapped = snapped;
    }

    public WindowBounds getBounds() {
        return this.bounds;
    }

    void setExternalWindowObserver(ExternalWindowObserver externalWindowObserver) {
        this.externalWindowObserver = externalWindowObserver;
    }

    ExternalWindowObserver getExternalWindowObserver() {
        return this.externalWindowObserver;
    }

    public void setBounds(WindowBounds bounds) {
        this.bounds = bounds;
    }

    public void updateBounds(WindowBounds bounds) {
        this.setBounds(bounds);
        logger.debug(String.format("setBounds %s %s", this.getKey(), bounds.toString()));
        this.window.setBounds(bounds.getLeft().intValue(), bounds.getTop().intValue(), bounds.getWidth().intValue(), bounds.getHeight().intValue(), this.ackListener);
    }

    void setAnchor(WindowMember member) {
        this.anchor = member;
    }

    WindowMember getAnchor() {
        return this.anchor;
    }

    List<WindowMember> getDockedChildren() {
        return this.dockedChildren;
    }

    public void dock(WindowMember movingMember) {
        try {
            logger.debug(String.format("Docking %s to %s", movingMember.getKey(), this.getKey()));
            movingMember.getWindow().joinGroup(this.window, this.ackListener);
            this.addDockChild(movingMember);
            this.setDocked(true);
            movingMember.setDocked(true);
        }
        catch (Exception ex) {
            logger.error(String.format("Error docking window %s", this.getKey()), (Throwable)ex);
        }
    }

    private void addDockChild(WindowMember child) {
        logger.debug(String.format("Add to docked children %s %s", this.getKey(), child.getKey()));
        child.setAnchor(this);
        this.dockedChildren.add(child);
    }

    private boolean isStandAlone() {
        return this.anchor == null && this.dockedChildren.size() == 0;
    }

    public void undock() {
        this.undock(true);
    }

    private void undock(boolean removeFromAnchor) {
        logger.debug(String.format("Undock %s", this.getKey()));
        if (this.isDocked()) {
            try {
                this.getWindow().leaveGroup(this.ackListener);
                this.setDocked(false);
                for (WindowMember child : this.dockedChildren) {
                    child.undock(false);
                }
                this.dockedChildren.clear();
                if (this.getAnchor() != null) {
                    WindowMember anchor = this.getAnchor();
                    if (removeFromAnchor) {
                        anchor.getDockedChildren().remove(this);
                        if (anchor.isStandAlone()) {
                            anchor.undock(true);
                        }
                    }
                    this.setAnchor(null);
                }
            }
            catch (Exception ex) {
                logger.error(String.format("Error undocking window %s", this.getKey()), (Throwable)ex);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowMember that = (WindowMember)o;
        return WindowMember.getMemberKey(this.window).equals(WindowMember.getMemberKey(that.window));
    }

    public int hashCode() {
        return WindowMember.getMemberKey(this.window).hashCode();
    }
}

