/*
 * Decompiled with CFR 0.152.
 */
package unified.vpn.sdk;

import android.content.Context;
import com.anchorfree.bolts.CancellationToken;
import com.anchorfree.bolts.CancellationTokenSource;
import com.anchorfree.bolts.Task;
import com.anchorfree.bolts.TaskCompletionSource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.SocketFactory;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionPool;
import okhttp3.Dns;
import okhttp3.EventListener;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import unified.vpn.sdk.ApiCallback;
import unified.vpn.sdk.CallbackData;
import unified.vpn.sdk.HttpClientConfigurer;
import unified.vpn.sdk.Logger;
import unified.vpn.sdk.PartnerRequestException;
import unified.vpn.sdk.ProtectedDns;
import unified.vpn.sdk.ProtectedSocketFactory;
import unified.vpn.sdk.SdkRequestBody;
import unified.vpn.sdk.Tls12Api19Compat;
import unified.vpn.sdk.VpnRouter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \"2\u00020\u0001:\u0004\u001f !\"B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b*\u0004\u0018\u00010\fH\u0002JB\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017JB\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0017J\b\u0010\u001b\u001a\u00020\u001cH\u0002JD\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lunified/vpn/sdk/SdkNetworkLayer;", "", "context", "Landroid/content/Context;", "clientConfigurator", "Lunified/vpn/sdk/HttpClientConfigurer;", "vpnRouter", "Lunified/vpn/sdk/VpnRouter;", "<init>", "(Landroid/content/Context;Lunified/vpn/sdk/HttpClientConfigurer;Lunified/vpn/sdk/VpnRouter;)V", "toBody", "Lokhttp3/RequestBody;", "Lunified/vpn/sdk/SdkRequestBody;", "genericRequest", "", "method", "Lunified/vpn/sdk/SdkNetworkLayer$RequestType;", "url", "", "body", "headers", "", "callback", "Lunified/vpn/sdk/ApiCallback;", "Lunified/vpn/sdk/CallbackData;", "genericRequestStream", "Ljava/io/InputStream;", "createClient", "Lokhttp3/OkHttpClient;", "execute", "Lokhttp3/Response;", "RequestType", "MappedCallback", "LoggingInterceptor", "Companion", "sdk-network-layer_release"})
public final class SdkNetworkLayer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final HttpClientConfigurer clientConfigurator;
    @NotNull
    private final VpnRouter vpnRouter;
    @NotNull
    private static final Logger logger = Logger.Companion.create("OkHttpNetworkLayer");
    private static final int DEFAULT_READ_TIMEOUT = 10;
    private static final int DEFAULT_CONNECT_TIMEOUT = 10;
    private static final int DEFAULT_CALL_TIMEOUT = 20;

    public SdkNetworkLayer(@NotNull Context context, @NotNull HttpClientConfigurer clientConfigurator, @NotNull VpnRouter vpnRouter) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)clientConfigurator, (String)"clientConfigurator");
        Intrinsics.checkNotNullParameter((Object)vpnRouter, (String)"vpnRouter");
        this.context = context;
        this.clientConfigurator = clientConfigurator;
        this.vpnRouter = vpnRouter;
    }

    private final RequestBody toBody(SdkRequestBody $this$toBody) {
        RequestBody requestBody;
        SdkRequestBody sdkRequestBody = $this$toBody;
        if (sdkRequestBody instanceof SdkRequestBody.FormBody) {
            FormBody.Builder formBuilder = new FormBody.Builder(null, 1, null);
            for (Map.Entry<String, String> entry : ((SdkRequestBody.FormBody)$this$toBody).getFields().entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (value == null) continue;
                formBuilder.add(key, value);
            }
            requestBody = (RequestBody)formBuilder.build();
        } else {
            requestBody = sdkRequestBody instanceof SdkRequestBody.JsonBody ? RequestBody.Companion.create(((SdkRequestBody.JsonBody)$this$toBody).getData(), MediaType.Companion.get("application/json")) : RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (String)"", null, (int)1, null);
        }
        return requestBody;
    }

    public final void genericRequest(@NotNull RequestType method, @NotNull String url, @Nullable SdkRequestBody body, @NotNull Map<String, String> headers, @NotNull ApiCallback<CallbackData> callback) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        MappedCallback<CallbackData> dataMappedCallback = new MappedCallback<CallbackData>(callback, SdkNetworkLayer::genericRequest$lambda$0);
        this.execute(method, url, body, headers, dataMappedCallback);
    }

    public final void genericRequestStream(@NotNull RequestType method, @NotNull String url, @Nullable SdkRequestBody body, @NotNull Map<String, String> headers, @NotNull ApiCallback<InputStream> callback) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        MappedCallback<InputStream> streamMappedCallback = new MappedCallback<InputStream>(callback, SdkNetworkLayer::genericRequestStream$lambda$1);
        this.execute(method, url, body, headers, streamMappedCallback);
    }

    private final OkHttpClient createClient() {
        ProtectedDns protectedDns = ProtectedDns.Companion.create(this.context, this.vpnRouter);
        ProtectedSocketFactory socketFactory = new ProtectedSocketFactory(this.vpnRouter);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.addInterceptor((Interceptor)new LoggingInterceptor(logger));
        builder.retryOnConnectionFailure(true);
        builder.readTimeout(10L, TimeUnit.SECONDS);
        builder.connectTimeout(10L, TimeUnit.SECONDS);
        builder.callTimeout(20L, TimeUnit.SECONDS);
        builder.writeTimeout(10L, TimeUnit.SECONDS);
        builder.connectionPool(new ConnectionPool(0, 1L, TimeUnit.NANOSECONDS));
        builder.protocols(CollectionsKt.listOf((Object)Protocol.HTTP_1_1));
        builder.retryOnConnectionFailure(true);
        builder.socketFactory((SocketFactory)socketFactory);
        ProtectedDns protectedDns2 = protectedDns;
        builder.dns(protectedDns2 != null ? (Dns)protectedDns2 : Dns.SYSTEM);
        Tls12Api19Compat.Companion.enableTls12OnPreLollipop(builder);
        builder.eventListener(new EventListener(socketFactory, protectedDns){
            final /* synthetic */ ProtectedSocketFactory $socketFactory;
            final /* synthetic */ ProtectedDns $protectedDns;
            {
                this.$socketFactory = $socketFactory;
                this.$protectedDns = $protectedDns;
            }

            public void callEnd(Call call) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    super.callEnd(call);
                    this.$socketFactory.clear();
                    ProtectedDns protectedDns = this.$protectedDns;
                    if (protectedDns == null) break block0;
                    protectedDns.clear();
                }
            }

            public void callFailed(Call call, IOException ioe) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    Intrinsics.checkNotNullParameter((Object)ioe, (String)"ioe");
                    super.callFailed(call, ioe);
                    this.$socketFactory.clear();
                    ProtectedDns protectedDns = this.$protectedDns;
                    if (protectedDns == null) break block0;
                    protectedDns.clear();
                }
            }
        });
        this.clientConfigurator.configure(builder);
        return builder.build();
    }

    private final void execute(RequestType method, String url, SdkRequestBody body, Map<String, String> headers, ApiCallback<Response> callback) {
        Request.Builder request = new Request.Builder().url(url);
        switch (WhenMappings.$EnumSwitchMapping$0[method.ordinal()]) {
            case 1: {
                Request.Builder builder = request.post(this.toBody(body));
                break;
            }
            case 2: {
                Request.Builder builder = request.put(this.toBody(body));
                break;
            }
            case 3: {
                Request.Builder builder = request.get();
                break;
            }
            case 4: {
                Request.Builder builder = Request.Builder.delete$default((Request.Builder)request, null, (int)1, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            request.addHeader(key, value);
        }
        OkHttpClient client = this.createClient();
        TaskCompletionSource tcs = new TaskCompletionSource();
        CancellationTokenSource cancellationTokenSource = new CancellationTokenSource();
        CancellationToken cancellationToken = cancellationTokenSource.getToken();
        Intrinsics.checkNotNullExpressionValue((Object)cancellationToken, (String)"getToken(...)");
        CancellationToken timeoutToken = cancellationToken;
        Task task = tcs.getTask();
        Intrinsics.checkNotNullExpressionValue((Object)task, (String)"getTask(...)");
        Task requestTask = task;
        timeoutToken.register(() -> SdkNetworkLayer.execute$lambda$2(tcs));
        cancellationTokenSource.cancelAfter(TimeUnit.SECONDS.toMillis(20L));
        client.newCall(request.build()).enqueue(new Callback((TaskCompletionSource<Response>)tcs){
            final /* synthetic */ TaskCompletionSource<Response> $tcs;
            {
                this.$tcs = $tcs;
            }

            public void onResponse(Call call, Response response) throws IOException {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                this.$tcs.trySetResult((Object)response);
            }

            public void onFailure(Call call, IOException e) {
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$tcs.trySetError((Exception)PartnerRequestException.Companion.fromTransport((Exception)e));
            }
        });
        requestTask.continueWith(arg_0 -> SdkNetworkLayer.execute$lambda$3(callback, arg_0));
    }

    private static final CallbackData genericRequest$lambda$0(Response response, ResponseBody responseBody) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)responseBody, (String)"responseBody");
        String apiId = Response.header$default((Response)response, (String)"x-amz-cf-id", null, (int)2, null);
        return new CallbackData(responseBody.string(), response.code(), apiId);
    }

    private static final InputStream genericRequestStream$lambda$1(Response response, ResponseBody responseBody) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)responseBody, (String)"responseBody");
        return responseBody.byteStream();
    }

    private static final void execute$lambda$2(TaskCompletionSource $tcs) {
        $tcs.trySetCancelled();
    }

    private static final Object execute$lambda$3(ApiCallback $callback, Task t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (t.isCancelled()) {
            $callback.failure(PartnerRequestException.Companion.unexpectedPartnerException((Throwable)new TimeoutException()));
        } else if (t.getError() != null) {
            Exception ex = t.getError();
            if (ex instanceof PartnerRequestException) {
                $callback.failure((PartnerRequestException)ex);
            } else {
                Intrinsics.checkNotNull((Object)ex);
                $callback.failure(PartnerRequestException.Companion.unexpectedPartnerException((Throwable)ex));
            }
        } else {
            Response result = (Response)t.getResult();
            if (result != null) {
                $callback.success(result);
            } else {
                $callback.failure(PartnerRequestException.Companion.unexpectedPartnerException((Throwable)new NullPointerException()));
            }
        }
        return null;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lunified/vpn/sdk/SdkNetworkLayer$Companion;", "", "<init>", "()V", "logger", "Lunified/vpn/sdk/Logger;", "DEFAULT_READ_TIMEOUT", "", "DEFAULT_CONNECT_TIMEOUT", "DEFAULT_CALL_TIMEOUT", "sdk-network-layer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lunified/vpn/sdk/SdkNetworkLayer$LoggingInterceptor;", "Lokhttp3/Interceptor;", "logger", "Lunified/vpn/sdk/Logger;", "<init>", "(Lunified/vpn/sdk/Logger;)V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "sdk-network-layer_release"})
    private static final class LoggingInterceptor
    implements Interceptor {
        @NotNull
        private final Logger logger;

        public LoggingInterceptor(@NotNull Logger logger) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.logger = logger;
        }

        @NotNull
        public Response intercept(@NotNull Interceptor.Chain chain) {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            try {
                Request request = chain.request();
                long t1 = System.nanoTime();
                Object[] objectArray = new Object[]{request.url().uri()};
                this.logger.info("Requesting %s", objectArray);
                Buffer buffer = new Buffer();
                RequestBody body = request.body();
                if (body != null) {
                    body.writeTo((BufferedSink)buffer);
                    Object[] objectArray2 = new Object[1];
                    Charset charset = Charset.defaultCharset();
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
                    objectArray2[0] = buffer.readString(charset);
                    this.logger.verbose("Body %s", objectArray2);
                }
                Response response = chain.proceed(request);
                long t2 = System.nanoTime();
                try {
                    Headers headers = response.headers();
                    for (String header : headers.names()) {
                        Object[] objectArray3 = new Object[]{header, headers.get(header)};
                        this.logger.verbose("%s: %s", objectArray3);
                    }
                    Object[] objectArray4 = new Object[]{response.request().url(), (double)(t2 - t1) / 1000000.0, response.code()};
                    this.logger.info("Response received for %s in %.1fms code: %s", objectArray4);
                }
                catch (Throwable e) {
                    this.logger.error(e);
                }
                return response;
            }
            catch (Throwable ex) {
                this.logger.error(ex);
                if (ex instanceof IOException) {
                    throw ex;
                }
                throw new IOException();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B/\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lunified/vpn/sdk/SdkNetworkLayer$MappedCallback;", "T", "Lunified/vpn/sdk/ApiCallback;", "Lokhttp3/Response;", "delegate", "map", "Lkotlin/Function2;", "Lokhttp3/ResponseBody;", "<init>", "(Lunified/vpn/sdk/ApiCallback;Lkotlin/jvm/functions/Function2;)V", "success", "", "response", "failure", "error", "Lunified/vpn/sdk/PartnerRequestException;", "sdk-network-layer_release"})
    private static final class MappedCallback<T>
    implements ApiCallback<Response> {
        @NotNull
        private final ApiCallback<T> delegate;
        @NotNull
        private final Function2<Response, ResponseBody, T> map;

        public MappedCallback(@NotNull ApiCallback<T> delegate, @NotNull Function2<? super Response, ? super ResponseBody, ? extends T> map) {
            Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
            Intrinsics.checkNotNullParameter(map, (String)"map");
            this.delegate = delegate;
            this.map = map;
        }

        @Override
        public void success(@NotNull Response response) {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            ResponseBody body = response.body();
            if (body != null) {
                this.delegate.success(this.map.invoke((Object)response, (Object)body));
            } else {
                this.delegate.failure(PartnerRequestException.Companion.unexpectedPartnerException((Throwable)new NullPointerException()));
            }
        }

        @Override
        public void failure(@NotNull PartnerRequestException error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            this.delegate.failure(error);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lunified/vpn/sdk/SdkNetworkLayer$RequestType;", "", "<init>", "(Ljava/lang/String;I)V", "GET", "POST", "PUT", "DELETE", "sdk-network-layer_release"})
    public static final class RequestType
    extends Enum<RequestType> {
        public static final /* enum */ RequestType GET = new RequestType();
        public static final /* enum */ RequestType POST = new RequestType();
        public static final /* enum */ RequestType PUT = new RequestType();
        public static final /* enum */ RequestType DELETE = new RequestType();
        private static final /* synthetic */ RequestType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RequestType[] values() {
            return (RequestType[])$VALUES.clone();
        }

        public static RequestType valueOf(String value) {
            return Enum.valueOf(RequestType.class, value);
        }

        @NotNull
        public static EnumEntries<RequestType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = requestTypeArray = new RequestType[]{RequestType.GET, RequestType.POST, RequestType.PUT, RequestType.DELETE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RequestType.values().length];
            try {
                nArray[RequestType.POST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestType.PUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestType.GET.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RequestType.DELETE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

