/*
 * Decompiled with CFR 0.152.
 */
package unified.vpn.sdk;

import com.anchorfree.bolts.Task;
import com.anchorfree.bolts.TaskCompletionSource;
import com.anchorfree.toolkit.utils.ObjectHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import unified.vpn.sdk.ApiCallback;
import unified.vpn.sdk.DownloadException;
import unified.vpn.sdk.Logger;
import unified.vpn.sdk.PartnerRequestException;
import unified.vpn.sdk.SdkNetworkLayer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lunified/vpn/sdk/FileDownloader;", "", "networkLayer", "Lunified/vpn/sdk/SdkNetworkLayer;", "<init>", "(Lunified/vpn/sdk/SdkNetworkLayer;)V", "download", "Lcom/anchorfree/bolts/Task;", "Ljava/io/InputStream;", "url", "", "downloadToFile", "Ljava/io/File;", "writeFile", "tmp", "stream", "Companion", "sdk-network-layer_release"})
@SourceDebugExtension(value={"SMAP\nFileDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileDownloader.kt\nunified/vpn/sdk/FileDownloader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class FileDownloader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SdkNetworkLayer networkLayer;
    @NotNull
    private static final Logger LOGGER = Logger.Companion.create("FileDownloader");

    public FileDownloader(@NotNull SdkNetworkLayer networkLayer) {
        Intrinsics.checkNotNullParameter((Object)networkLayer, (String)"networkLayer");
        this.networkLayer = networkLayer;
    }

    @NotNull
    public final Task<InputStream> download(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        TaskCompletionSource tsc = new TaskCompletionSource();
        Object[] objectArray = new Object[]{url};
        LOGGER.verbose("Download from %s", objectArray);
        this.networkLayer.genericRequestStream(SdkNetworkLayer.RequestType.GET, url, null, MapsKt.emptyMap(), new ApiCallback<InputStream>((TaskCompletionSource<InputStream>)tsc){
            final /* synthetic */ TaskCompletionSource<InputStream> $tsc;
            {
                this.$tsc = $tsc;
            }

            public void failure(PartnerRequestException error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                this.$tsc.trySetError((Exception)new DownloadException());
            }

            public void success(InputStream response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                this.$tsc.trySetResult((Object)response);
            }
        });
        Task task = tsc.getTask();
        Intrinsics.checkNotNullExpressionValue((Object)task, (String)"getTask(...)");
        return task;
    }

    @NotNull
    public final Task<File> downloadToFile(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Task task = this.download(url).continueWith(arg_0 -> FileDownloader.downloadToFile$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)task, (String)"continueWith(...)");
        return task;
    }

    private final File writeFile(File tmp, InputStream stream) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(tmp);
        StringBuilder builder = new StringBuilder();
        int len = 0;
        byte[] bytes = new byte[10240];
        while (true) {
            Charset charset;
            int n;
            int it = n = stream.read(bytes);
            boolean bl = false;
            len = it;
            if (n <= 0) break;
            n = 0;
            int n2 = len;
            Intrinsics.checkNotNullExpressionValue((Object)Charset.defaultCharset(), (String)"defaultCharset(...)");
            builder.append(new String(bytes, n, n2, charset));
            fileOutputStream.write(bytes, 0, len);
        }
        fileOutputStream.close();
        return tmp;
    }

    private static final File downloadToFile$lambda$0(FileDownloader this$0, Task t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (!t.isFaulted()) {
            Object object = ObjectHelper.requireNonNull((Object)t.getResult());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"requireNonNull(...)");
            InputStream stream = (InputStream)object;
            File tmp = File.createTempFile("remote", "file");
            Intrinsics.checkNotNull((Object)tmp);
            return this$0.writeFile(tmp, stream);
        }
        throw t.getError();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lunified/vpn/sdk/FileDownloader$Companion;", "", "<init>", "()V", "LOGGER", "Lunified/vpn/sdk/Logger;", "sdk-network-layer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

