/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.collection;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class ConcurrentMapComplex<K, V> {
    protected final ConcurrentMap<K, V> map;

    public ConcurrentMapComplex(ConcurrentMap<K, V> map) {
        this.map = map;
    }

    public ConcurrentMapComplex() {
        this.map = new ConcurrentHashMap();
    }

    public V getOrAllocate(K key) {
        V tmp;
        Object coll = this.map.get(key);
        if (coll == null && (tmp = this.map.putIfAbsent(key, coll = this.allocateElement())) != null) {
            coll = tmp;
        }
        return coll;
    }

    public V get(K key) {
        Object value = this.map.get(key);
        return value != null ? value : this.emptyElement();
    }

    public void remove(K key) {
        this.map.remove(key);
    }

    protected abstract V allocateElement();

    protected abstract V emptyElement();
}

