/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.collection;

import co.paralleluniverse.common.collection.ConcurrentMapComplex;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public abstract class ConcurrentMultimap<K, V, C extends Collection<V>>
extends ConcurrentMapComplex<K, C> {
    private final C emptyCollection;

    public ConcurrentMultimap(ConcurrentMap<K, C> map, C emptyCollection) {
        super(map);
        this.emptyCollection = emptyCollection;
    }

    public ConcurrentMultimap(C emptyCollection) {
        this.emptyCollection = emptyCollection;
    }

    @Override
    protected C emptyElement() {
        return this.emptyCollection;
    }

    public void put(K key, V value) {
        ((Collection)this.getOrAllocate(key)).add(value);
    }

    public void put(K key, Collection<V> values) {
        ((Collection)this.getOrAllocate(key)).addAll(values);
    }

    public void remove(K key, V value) {
        Collection coll = (Collection)this.get(key);
        if (coll == null) {
            return;
        }
        coll.remove(value);
    }

    public Collection<C> values() {
        return this.map.values();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }
}

