/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.collection;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class ConcurrentSet<E>
extends AbstractSet<E>
implements Set<E> {
    private final ConcurrentMap<E, Object> map;
    private static final Object PRESENT = new Object();

    public static <E> Set<E> make(ConcurrentMap<E, Object> map) {
        return new ConcurrentSet<E>(map);
    }

    public ConcurrentSet(ConcurrentMap<E, Object> map) {
        this.map = map;
    }

    public ConcurrentSet(ConcurrentMap<E, Object> map, Collection<E> elements) {
        for (E elem : elements) {
            map.put(elem, PRESENT);
        }
        this.map = map;
    }

    @Override
    public boolean add(E e) {
        return this.map.putIfAbsent(e, PRESENT) != PRESENT;
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }
}

