/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.collection;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class MultiLane<T> {
    private final LinkedBlockingQueue<T>[] lanes;
    private final AtomicInteger putCursor = new AtomicInteger();
    private final AtomicInteger takeCursor = new AtomicInteger();

    public MultiLane(int width) {
        if (width <= 0) {
            throw new IllegalArgumentException("width must be positive but is " + width);
        }
        if ((width & width - 1) != 0) {
            throw new IllegalArgumentException("width must be a power of 2 but is " + width);
        }
        this.lanes = new LinkedBlockingQueue[width];
        for (int i = 0; i < width; ++i) {
            this.lanes[i] = new LinkedBlockingQueue();
        }
    }

    public void put(T v) throws InterruptedException {
        int curs = this.putCursor.getAndIncrement();
        this.lanes[curs & this.lanes.length - 1].put(v);
    }

    public T take() throws InterruptedException {
        int curs = this.takeCursor.getAndIncrement();
        return this.lanes[curs & this.lanes.length - 1].take();
    }
}

