/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.collection;

import gnu.trove.TLongCollection;
import gnu.trove.iterator.TLongIterator;
import gnu.trove.procedure.TLongProcedure;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;

public abstract class TLongAbstractCollection
implements TLongCollection {
    public static final TLongCollection EMPTY_COLLECTION = new TLongAbstractCollection(){

        @Override
        public int size() {
            return 0;
        }

        @Override
        public TLongIterator iterator() {
            return new TLongIterator(){

                public boolean hasNext() {
                    return false;
                }

                public long next() {
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    };
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public abstract int size();

    public abstract TLongIterator iterator();

    public long getNoEntryValue() {
        return 0L;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(long entry) {
        TLongIterator it = this.iterator();
        while (it.hasNext()) {
            if (entry != it.next()) continue;
            return true;
        }
        return false;
    }

    public long[] toArray() {
        long[] dest = new long[this.size()];
        TLongIterator it = this.iterator();
        for (int i = 0; i < dest.length; ++i) {
            if (!it.hasNext()) {
                return Arrays.copyOf(dest, i);
            }
            dest[i] = it.next();
        }
        return it.hasNext() ? TLongAbstractCollection.finishToArray(dest, it) : dest;
    }

    private static long[] finishToArray(long[] r, TLongIterator it) {
        int i = r.length;
        while (it.hasNext()) {
            int cap = r.length;
            if (i == cap) {
                int newCap = cap + (cap >> 1) + 1;
                if (newCap - 0x7FFFFFF7 > 0) {
                    newCap = TLongAbstractCollection.hugeCapacity(cap + 1);
                }
                r = Arrays.copyOf(r, newCap);
            }
            r[i++] = it.next();
        }
        return i == r.length ? r : Arrays.copyOf(r, i);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError("Required array size too large");
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    public long[] toArray(long[] dest) {
        TLongIterator it = this.iterator();
        for (int i = 0; i < dest.length; ++i) {
            if (!it.hasNext()) {
                dest[i] = this.getNoEntryValue();
                break;
            }
            dest[i] = it.next();
        }
        return dest;
    }

    public boolean add(long entry) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(long entry) {
        TLongIterator it = this.iterator();
        while (it.hasNext()) {
            if (entry != it.next()) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection<?> collection) {
        for (Object e : collection) {
            if (this.contains((Long)e)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(TLongCollection collection) {
        TLongIterator it = collection.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(long[] array) {
        for (long e : array) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection<? extends Long> collection) {
        boolean modified = false;
        for (Long l : collection) {
            if (!this.add(l)) continue;
            modified = true;
        }
        return modified;
    }

    public boolean addAll(TLongCollection collection) {
        boolean modified = false;
        TLongIterator it = collection.iterator();
        while (it.hasNext()) {
            if (!this.add(it.next())) continue;
            modified = true;
        }
        return modified;
    }

    public boolean addAll(long[] array) {
        boolean modified = false;
        for (long e : array) {
            if (!this.add(e)) continue;
            modified = true;
        }
        return modified;
    }

    public boolean removeAll(Collection<?> collection) {
        boolean modified = false;
        TLongIterator it = this.iterator();
        while (it.hasNext()) {
            if (!collection.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    public boolean removeAll(TLongCollection collection) {
        boolean modified = false;
        TLongIterator it = this.iterator();
        while (it.hasNext()) {
            if (!collection.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    public boolean removeAll(long[] array) {
        boolean modified = false;
        TLongIterator it = this.iterator();
        while (it.hasNext()) {
            if (!TLongAbstractCollection.contains(array, it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(Collection<?> collection) {
        boolean modified = false;
        TLongIterator it = this.iterator();
        while (it.hasNext()) {
            if (collection.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(TLongCollection collection) {
        boolean modified = false;
        TLongIterator it = this.iterator();
        while (it.hasNext()) {
            if (collection.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(long[] array) {
        boolean modified = false;
        TLongIterator it = this.iterator();
        while (it.hasNext()) {
            if (TLongAbstractCollection.contains(array, it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    public void clear() {
        TLongIterator it = this.iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
    }

    public boolean forEach(TLongProcedure procedure) {
        TLongIterator it = this.iterator();
        while (it.hasNext()) {
            if (procedure.execute(it.next())) continue;
            return false;
        }
        return true;
    }

    private static boolean contains(long[] array, long value) {
        for (long e : array) {
            if (e != value) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        TLongIterator it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            long e = it.next();
            sb.append(e);
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }
}

