/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.collection;

import co.paralleluniverse.common.collection.TLongAbstractCollection;
import gnu.trove.TLongCollection;
import gnu.trove.iterator.TLongIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class TLongCompoundCollection
extends TLongAbstractCollection {
    private Collection<TLongCollection> collections = new ArrayList<TLongCollection>();

    public void addCollection(TLongCollection c) {
        this.collections.add(c);
    }

    public void removeCollection(TLongCollection c) {
        this.collections.remove(c);
    }

    @Override
    public int size() {
        int size = 0;
        for (TLongCollection c : this.collections) {
            size += c.size();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        for (TLongCollection c : this.collections) {
            if (c.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public TLongIterator iterator() {
        return new TLongIterator(){
            private Iterator<TLongCollection> ce;
            private TLongIterator i;
            {
                this.ce = TLongCompoundCollection.this.collections.iterator();
                this.i = null;
            }

            public boolean hasNext() {
                this.setIterator();
                if (this.i == null) {
                    return false;
                }
                return this.i.hasNext();
            }

            public long next() {
                this.setIterator();
                if (this.i == null) {
                    throw new NoSuchElementException();
                }
                return this.i.next();
            }

            public void remove() {
                this.i.remove();
            }

            private void setIterator() {
                if ((this.i == null || !this.i.hasNext()) && this.ce.hasNext()) {
                    this.i = this.ce.next().iterator();
                }
            }
        };
    }

    @Override
    public void clear() {
        for (TLongCollection c : this.collections) {
            c.clear();
        }
    }

    @Override
    public boolean contains(long value) {
        for (TLongCollection c : this.collections) {
            if (!c.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(long value) {
        boolean retValue = false;
        for (TLongCollection c : this.collections) {
            retValue |= c.remove(value);
        }
        return retValue;
    }
}

