/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.concurrent;

import co.paralleluniverse.common.concurrent.QueueFactory;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OrderedThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(OrderedThreadPoolExecutor.class);
    protected final ConcurrentMap<Object, Executor> childExecutors = new ConcurrentHashMap<Object, Executor>();
    private final int maxQueueSize;

    public OrderedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, int maxQueueSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new SynchronousQueue<Runnable>(), threadFactory, handler);
        this.maxQueueSize = maxQueueSize;
    }

    public OrderedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, int maxQueueSize, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new SynchronousQueue<Runnable>(), handler);
        this.maxQueueSize = maxQueueSize;
    }

    public OrderedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, int maxQueueSize, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new SynchronousQueue<Runnable>(), threadFactory);
        this.maxQueueSize = maxQueueSize;
    }

    public OrderedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, int maxQueueSize) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new SynchronousQueue<Runnable>());
        this.maxQueueSize = maxQueueSize;
    }

    @Override
    public void execute(Runnable task) {
        assert (!(task instanceof ChildExecutor));
        this.getChildExecutor(task).execute(task);
    }

    protected abstract Object getChildExecutorKey(Runnable var1);

    protected boolean removeChildExecutor(Object key) {
        return this.childExecutors.remove(key) != null;
    }

    protected Executor getChildExecutor(Runnable task) {
        Executor oldExecutor;
        Object key = this.getChildExecutorKey(task);
        Executor executor = (Executor)this.childExecutors.get(key);
        if (executor == null && (oldExecutor = this.childExecutors.putIfAbsent(key, executor = new ChildExecutor())) != null) {
            executor = oldExecutor;
        }
        return executor;
    }

    private final class ChildExecutor
    implements Executor,
    Runnable {
        private final Queue<Runnable> tasks;
        private boolean running;

        private ChildExecutor() {
            this.tasks = QueueFactory.getInstance(OrderedThreadPoolExecutor.this.maxQueueSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            boolean start = false;
            ChildExecutor childExecutor = this;
            synchronized (childExecutor) {
                try {
                    this.tasks.add(command);
                }
                catch (IllegalStateException ex) {
                    LOG.error("my queue full", (Throwable)ex);
                    throw ex;
                }
                if (!this.running) {
                    this.running = true;
                    start = true;
                }
            }
            if (start) {
                try {
                    OrderedThreadPoolExecutor.super.execute(this);
                }
                catch (Exception e) {
                    LOG.error("exexution failed. poolsize {}. activeCount {}", (Object)OrderedThreadPoolExecutor.super.getPoolSize(), (Object)OrderedThreadPoolExecutor.super.getActiveCount());
                    throw e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread thread = Thread.currentThread();
            while (true) {
                Runnable task;
                ChildExecutor childExecutor = this;
                synchronized (childExecutor) {
                    task = this.tasks.poll();
                    if (task == null) {
                        this.running = false;
                        break;
                    }
                }
                OrderedThreadPoolExecutor.this.beforeExecute(thread, task);
                try {
                    task.run();
                    OrderedThreadPoolExecutor.this.afterExecute(task, null);
                }
                catch (RuntimeException e) {
                    OrderedThreadPoolExecutor.this.afterExecute(task, e);
                    LOG.error("Error while executing task " + task, (Throwable)e);
                }
            }
        }
    }
}

