/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SimpleFuture<V>
implements Future<V> {
    private final Lock lock = new ReentrantLock();
    private final Condition cond = this.lock.newCondition();
    private volatile boolean done;
    private V result;
    private Throwable exception;

    @Override
    public boolean isDone() {
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.lock.lock();
        try {
            while (!this.done) {
                this.cond.await();
            }
            V v = this.getResult();
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.lock.lock();
        try {
            if (!this.cond.await(timeout, unit)) {
                throw new TimeoutException();
            }
            V v = this.getResult();
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    private V getResult() throws ExecutionException {
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    public void setResult(V result) {
        this.result = result;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        this.lock.lock();
        try {
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done(V result) {
        this.lock.lock();
        try {
            this.setResult(result);
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed(Throwable exception) {
        this.lock.lock();
        try {
            this.setException(exception);
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean isCancelled() {
        return false;
    }
}

