/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.io;

import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream
extends OutputStream
implements DataOutput {
    private final ByteBuffer buffer;

    public ByteBufferOutputStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void write(int b) throws IOException {
        try {
            this.buffer.put((byte)b);
        }
        catch (BufferOverflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        try {
            this.buffer.put(b);
        }
        catch (BufferOverflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.buffer.put(b, off, len);
        }
        catch (BufferOverflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        try {
            this.buffer.put(v ? (byte)1 : 0);
        }
        catch (BufferOverflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        byte[] b = s.getBytes();
        this.write(b);
    }

    @Override
    public void writeChar(int v) throws IOException {
        try {
            this.buffer.putChar((char)v);
        }
        catch (BufferUnderflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        try {
            for (int i = 0; i < s.length(); ++i) {
                this.buffer.putChar(s.charAt(i));
            }
        }
        catch (BufferOverflowException e) {
            throw new EOFException();
        }
    }

    @Override
    public void writeDouble(double v) throws IOException {
        try {
            this.buffer.putDouble(v);
        }
        catch (BufferOverflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeFloat(float v) throws IOException {
        try {
            this.buffer.putFloat(v);
        }
        catch (BufferOverflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeInt(int v) throws IOException {
        try {
            this.buffer.putInt(v);
        }
        catch (BufferOverflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeLong(long v) throws IOException {
        try {
            this.buffer.putLong(v);
        }
        catch (BufferOverflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeShort(int v) throws IOException {
        try {
            this.buffer.putShort((short)v);
        }
        catch (BufferOverflowException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        throw new UnsupportedOperationException();
    }
}

