/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.io;

import co.paralleluniverse.common.io.ByteBufferUtil;
import co.paralleluniverse.common.io.Checksum;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import java.nio.ByteBuffer;

public class HashFunctionChecksum
implements Checksum {
    private final HashFunction hf;
    private Hasher hasher;

    public HashFunctionChecksum(HashFunction hf) {
        this.hf = hf;
        this.reset();
    }

    @Override
    public void reset() {
        this.hasher = this.hf.newHasher();
    }

    @Override
    public void update(byte b) {
        this.hasher.putByte(b);
    }

    @Override
    public void update(byte[] array) {
        this.hasher.putBytes(array);
    }

    @Override
    public void update(ByteBuffer buffer) {
        this.hasher.putBytes(ByteBufferUtil.toByteArray(buffer));
    }

    @Override
    public byte[] getChecksum() {
        return this.hasher.hash().asBytes();
    }
}

