/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.io;

import co.paralleluniverse.common.io.Checksum;
import com.google.common.primitives.Longs;
import java.nio.ByteBuffer;

class Hasher
implements Checksum {
    private static final long START = -4953706369002393500L;
    private static final long MULT = 7664345821815920749L;
    private static final long[] TABLE = Hasher.createLookupTable();
    private long value;

    public Hasher() {
        this.reset();
    }

    @Override
    public final void reset() {
        this.value = -4953706369002393500L;
    }

    @Override
    public byte[] getChecksum() {
        return Longs.toByteArray((long)this.value);
    }

    @Override
    public void update(byte b) {
        this.value = this.value * 7664345821815920749L ^ TABLE[b & 0xFF];
    }

    @Override
    public void update(byte[] array) {
        for (byte b : array) {
            this.update(b);
        }
    }

    @Override
    public void update(ByteBuffer buffer) {
        while (buffer.hasRemaining()) {
            this.update(buffer.get());
        }
    }

    private static long[] createLookupTable() {
        long[] table = new long[256];
        long h = 6074001001750140548L;
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 31; ++j) {
                h = h >>> 7 ^ h;
                h = h << 11 ^ h;
                h = h >>> 10 ^ h;
            }
            table[i] = h;
        }
        return table;
    }
}

