/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.io;

import co.paralleluniverse.common.io.ByteBufferInputStream;
import co.paralleluniverse.common.io.ByteBufferOutputStream;
import co.paralleluniverse.common.io.Persistable;
import co.paralleluniverse.common.io.Streamable;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class Persistables {
    public static Persistable persistable(final Streamable streamable) {
        return new Persistable(){

            @Override
            public int size() {
                return streamable.size();
            }

            @Override
            public void write(ByteBuffer buffer) {
                try {
                    streamable.write(new ByteBufferOutputStream(buffer));
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public void read(ByteBuffer buffer) {
                try {
                    streamable.read(new ByteBufferInputStream(buffer));
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
    }

    public static Persistable persistable(final ByteBuffer buffer) {
        return new Persistable(){

            @Override
            public int size() {
                return buffer.limit();
            }

            @Override
            public void write(ByteBuffer buffer1) {
                buffer1.put(buffer);
                buffer1.flip();
            }

            @Override
            public void read(ByteBuffer buffer1) {
                buffer.rewind();
                buffer.put(buffer1);
                buffer.rewind();
            }
        };
    }

    public static byte[] toByteArray(ByteBuffer buffer) {
        if (buffer.hasArray() && buffer.arrayOffset() == 0 && buffer.position() == 0 && buffer.limit() == buffer.capacity() && buffer.array().length == buffer.capacity()) {
            byte[] array = buffer.array();
            return array;
        }
        int p = buffer.position();
        byte[] array = new byte[buffer.remaining()];
        buffer.get(array);
        buffer.position(p);
        return array;
    }

    public static ByteBuffer copyOf(ByteBuffer buffer) {
        int n = buffer.capacity();
        ByteBuffer buffer2 = ByteBuffer.allocate(n);
        int p = buffer.position();
        buffer.position(0);
        int l = buffer.limit();
        buffer.limit(n);
        buffer2.put(buffer);
        buffer2.flip();
        buffer.position(p);
        buffer.limit(l);
        return buffer2;
    }

    public static ByteBuffer slice(ByteBuffer buffer, int start, int length) {
        int l = buffer.limit();
        int p = buffer.position();
        buffer.limit(start + length);
        buffer.position(start);
        ByteBuffer slice = buffer.slice();
        buffer.limit(l);
        buffer.position(p);
        return slice;
    }

    public static ByteBuffer slice(ByteBuffer buffer, int length) {
        int l = buffer.limit();
        buffer.limit(buffer.position() + length);
        ByteBuffer slice = buffer.slice();
        buffer.limit(l);
        buffer.position(buffer.position() + length);
        return slice;
    }

    private Persistables() {
    }
}

