/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.io;

import co.paralleluniverse.common.io.Streamable;
import com.google.common.base.Throwables;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class Streamables {
    private final ConcurrentMap<Byte, ClassInfo> types = new ConcurrentHashMap<Byte, ClassInfo>();

    public static byte[] toByteArray(Streamable streamable) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(streamable.size());
            DataOutputStream dos = new DataOutputStream(baos);
            streamable.write(dos);
            dos.flush();
            baos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void fromByteArray(Streamable streamable, byte[] array) {
        Streamables.fromByteArray(streamable, array, 0, array.length);
    }

    public static void fromByteArray(Streamable streamable, byte[] array, int offset) {
        Streamables.fromByteArray(streamable, array, offset, array.length - offset);
    }

    public static void fromByteArray(Streamable streamable, byte[] array, int offset, int length) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(array, offset, length);
            DataInputStream dis = new DataInputStream(bais);
            streamable.read(dis);
            bais.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeBuffer(DataOutput out, ByteBuffer buffer) throws IOException {
        if (buffer.hasArray()) {
            out.write(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
            buffer.position(buffer.limit());
        } else {
            byte[] array = new byte[buffer.remaining()];
            buffer.get(array);
            assert (buffer.remaining() == 0 && buffer.position() == buffer.limit());
            out.write(array);
        }
    }

    public static int calcUtfLength(String str) {
        int strlen = str.length();
        int utflen = 0;
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        return utflen;
    }

    public <T extends Streamable> void register(byte qualifier, Class<T> clazz) {
        ClassInfo<T> old = this.types.putIfAbsent(qualifier, new ClassInfo<T>(clazz));
        if (old != null) {
            throw new RuntimeException("Qualifier " + qualifier + " is already registered to class " + old.clazz.getName());
        }
    }

    public Object read(DataInput in) throws IOException {
        byte qualifier = in.readByte();
        ClassInfo ci = (ClassInfo)this.types.get(qualifier);
        if (ci == null) {
            throw new IOException("Cannot read object. No class registered for qualifier " + qualifier);
        }
        Streamable obj = (Streamable)ci.construct(qualifier);
        obj.read(in);
        return obj;
    }

    public Object fromByteArray(byte[] array) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(array);
        DataInputStream dis = new DataInputStream(bais);
        Object obj = this.read(dis);
        bais.close();
        return obj;
    }

    private static class ClassInfo<T> {
        public final Class<T> clazz;
        private final boolean constructorWithQualifier;
        private final Constructor<T> constructor;

        public ClassInfo(Class<T> clazz) {
            try {
                boolean _constructorWithQualifier = false;
                Constructor<T> _constructor = null;
                try {
                    _constructor = clazz.getDeclaredConstructor(Byte.TYPE);
                    _constructorWithQualifier = true;
                }
                catch (NoSuchMethodException ex) {
                    // empty catch block
                }
                if (_constructor == null) {
                    try {
                        _constructor = clazz.getDeclaredConstructor(new Class[0]);
                        _constructorWithQualifier = false;
                    }
                    catch (NoSuchMethodException ex) {
                        // empty catch block
                    }
                }
                if (_constructor == null) {
                    throw new IllegalArgumentException("Class " + clazz.getName() + " does not have a default constructor or one that takes a byte as parameter");
                }
                this.clazz = clazz;
                this.constructorWithQualifier = _constructorWithQualifier;
                this.constructor = _constructor;
            }
            catch (SecurityException ex) {
                throw new RuntimeException(ex);
            }
        }

        public T construct(byte type) {
            try {
                if (this.constructorWithQualifier) {
                    return this.constructor.newInstance(type);
                }
                return this.constructor.newInstance(new Object[0]);
            }
            catch (InstantiationException ex) {
                throw Throwables.propagate((Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                throw Throwables.propagate((Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                throw Throwables.propagate((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                throw Throwables.propagate((Throwable)ex);
            }
        }
    }
}

