/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.monitoring;

import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class Monitor<T>
implements InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(Monitor.class);
    private final String name;
    private boolean registered;
    private final WeakReference<T> monitored;

    public Monitor(String name, T monitored) {
        this.name = name;
        this.monitored = new WeakReference<T>(monitored);
    }

    public void afterPropertiesSet() throws Exception {
        this.registerMBean();
    }

    public void destroy() throws Exception {
        this.unregisterMBean();
    }

    protected T getMonitored() {
        Object m = this.monitored.get();
        if (m == null) {
            this.unregisterMBean();
        }
        return m;
    }

    protected boolean isMonitoredObjectAlive() {
        return this.monitored == null || this.monitored.get() != null;
    }

    public void registerMBean() {
        try {
            LOG.info("Registering MBean {}", (Object)this.name);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName(this.name);
            mbs.registerMBean(this, mxbeanName);
            this.registered = true;
        }
        catch (InstanceAlreadyExistsException ex) {
            throw new RuntimeException(ex);
        }
        catch (MBeanRegistrationException ex) {
            throw new RuntimeException(ex);
        }
        catch (NotCompliantMBeanException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (MalformedObjectNameException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public void unregisterMBean() {
        try {
            if (this.registered) {
                LOG.info("Unregistering MBean {}", (Object)this.name);
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(new ObjectName(this.name));
            }
            this.registered = false;
        }
        catch (Exception e) {
            LOG.warn("Exception:", (Throwable)e);
        }
    }
}

