/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.monitoring;

import java.lang.management.ManagementFactory;
import java.lang.ref.WeakReference;
import java.util.Date;
import javax.management.AttributeChangeNotification;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.StandardEmitterMBean;
import javax.management.timer.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class PeriodicMonitor
extends StandardEmitterMBean
implements NotificationListener,
NotificationEmitter,
InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(PeriodicMonitor.class);
    private final String name;
    private boolean registered;
    private long lastCollectTime;
    private int notificationSequenceNumber;
    private WeakReference<Object> monitored;
    private boolean timerStarted;
    private int timerPeriod = 5000;
    private final Timer timer = new Timer();

    public PeriodicMonitor(Class mbeanInterface, String name) {
        super(mbeanInterface, true, (NotificationEmitter)new NotificationBroadcasterSupport());
        this.name = name;
        this.lastCollectTime = System.currentTimeMillis();
        this.monitored = null;
    }

    public void afterPropertiesSet() throws Exception {
        this.collectAndResetCounters1();
        this.registerMBean();
    }

    public void destroy() throws Exception {
        this.unregisterMBean();
    }

    public void setMonitoredObject(Object obj) {
        this.monitored = new WeakReference<Object>(obj);
    }

    private boolean isMonitoredObjectAlive() {
        return this.monitored == null || this.monitored.get() != null;
    }

    private void registerMBean() {
        try {
            LOG.info("Registering MBean {}", (Object)this.name);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName(this.name);
            mbs.registerMBean(this, mxbeanName);
            this.timer.addNotificationListener(this, new NotificationFilter(){

                @Override
                public boolean isNotificationEnabled(Notification notification) {
                    return "tickTimer".equals(notification.getType());
                }
            }, null);
            this.registered = true;
        }
        catch (InstanceAlreadyExistsException ex) {
            throw new RuntimeException(ex);
        }
        catch (MBeanRegistrationException ex) {
            throw new RuntimeException(ex);
        }
        catch (NotCompliantMBeanException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (MalformedObjectNameException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public void unregisterMBean() {
        try {
            if (this.registered) {
                LOG.info("Unregistering MBean {}", (Object)this.name);
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(new ObjectName(this.name));
                this.timer.stop();
            }
            this.registered = false;
        }
        catch (Exception e) {
            LOG.warn("Exception:", (Throwable)e);
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{"jmx.attribute.change"};
        String _name = AttributeChangeNotification.class.getName();
        String description = "An attribute of this MBean has changed";
        MBeanNotificationInfo info = new MBeanNotificationInfo(types, _name, description);
        return new MBeanNotificationInfo[]{info};
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if ("tickTimer".equals(notification.getType())) {
            this.refresh();
        }
    }

    public void refresh() {
        this.collectAndResetCounters1();
        AttributeChangeNotification n = new AttributeChangeNotification(this, this.notificationSequenceNumber++, System.currentTimeMillis(), "Info changed", "", null, null, null);
        this.sendNotification(n);
    }

    protected long getMillisSinceLastCollect() {
        return System.currentTimeMillis() - this.lastCollectTime;
    }

    public synchronized int getTimerPeriod() {
        return this.timerPeriod;
    }

    public synchronized void setTimerPeriod(int timerPeriod) {
        if (timerPeriod != this.timerPeriod) {
            this.timerPeriod = timerPeriod;
            if (this.timerStarted) {
                this.stopUpdates();
                this.startUpdates();
            }
        }
    }

    public synchronized boolean isUpdates() {
        return this.timerStarted;
    }

    public synchronized void setUpdates(boolean value) {
        if (value == this.timerStarted) {
            return;
        }
        if (!this.timerStarted) {
            this.startUpdates();
        } else {
            this.stopUpdates();
        }
    }

    public synchronized void startUpdates() {
        if (!this.timerStarted) {
            this.timer.addNotification("tickTimer", null, null, new Date(System.currentTimeMillis()), this.timerPeriod);
            this.timerStarted = true;
            this.timer.start();
        }
    }

    public synchronized void stopUpdates() {
        if (this.timerStarted) {
            try {
                this.timer.removeNotifications("tickTimer");
                this.timerStarted = false;
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                // empty catch block
            }
            this.timer.stop();
        }
    }

    private void collectAndResetCounters1() {
        if (this.registered) {
            if (!this.isMonitoredObjectAlive()) {
                this.unregisterMBean();
            } else {
                this.collectAndResetCounters();
                this.lastCollectTime = System.currentTimeMillis();
                return;
            }
        }
        this.resetCounters();
        this.lastCollectTime = System.currentTimeMillis();
    }

    protected void initCounters() {
    }

    protected abstract void collectAndResetCounters();

    protected abstract void resetCounters();
}

