/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.monitoring;

import co.paralleluniverse.common.monitoring.Monitor;
import co.paralleluniverse.common.monitoring.ThreadPoolExecutorMXBean;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolExecutorMonitor
extends Monitor<ThreadPoolExecutor>
implements ThreadPoolExecutorMXBean {
    public static void register(String name, ThreadPoolExecutor executor) {
        new ThreadPoolExecutorMonitor(name, executor);
    }

    public ThreadPoolExecutorMonitor(String name, ThreadPoolExecutor executor) {
        super("co.paralleluniverse:type=ThreadPoolExecutor,name=" + name, executor);
        this.registerMBean();
    }

    @Override
    public boolean isTerminating() {
        ThreadPoolExecutor executor = (ThreadPoolExecutor)this.getMonitored();
        if (executor == null) {
            return false;
        }
        return executor.isTerminating();
    }

    @Override
    public boolean isTerminated() {
        ThreadPoolExecutor executor = (ThreadPoolExecutor)this.getMonitored();
        if (executor == null) {
            return false;
        }
        return executor.isTerminated();
    }

    @Override
    public boolean isShutdown() {
        ThreadPoolExecutor executor = (ThreadPoolExecutor)this.getMonitored();
        if (executor == null) {
            return false;
        }
        return executor.isShutdown();
    }

    @Override
    public long getTaskCount() {
        ThreadPoolExecutor executor = (ThreadPoolExecutor)this.getMonitored();
        if (executor == null) {
            return -1L;
        }
        return executor.getTaskCount();
    }

    @Override
    public String getRejectedExecutionHandler() {
        ThreadPoolExecutor executor = (ThreadPoolExecutor)this.getMonitored();
        if (executor == null) {
            return null;
        }
        return executor.getRejectedExecutionHandler().toString();
    }

    @Override
    public int getPoolSize() {
        ThreadPoolExecutor executor = (ThreadPoolExecutor)this.getMonitored();
        if (executor == null) {
            return -1;
        }
        return executor.getPoolSize();
    }

    @Override
    public int getMaximumPoolSize() {
        ThreadPoolExecutor executor = (ThreadPoolExecutor)this.getMonitored();
        if (executor == null) {
            return -1;
        }
        return executor.getMaximumPoolSize();
    }

    @Override
    public int getLargestPoolSize() {
        ThreadPoolExecutor executor = (ThreadPoolExecutor)this.getMonitored();
        if (executor == null) {
            return -1;
        }
        return executor.getLargestPoolSize();
    }

    @Override
    public long getKeepAliveTime() {
        ThreadPoolExecutor executor = (ThreadPoolExecutor)this.getMonitored();
        if (executor == null) {
            return -1L;
        }
        return executor.getKeepAliveTime(TimeUnit.MILLISECONDS);
    }

    @Override
    public int getCorePoolSize() {
        ThreadPoolExecutor executor = (ThreadPoolExecutor)this.getMonitored();
        if (executor == null) {
            return -1;
        }
        return executor.getCorePoolSize();
    }

    @Override
    public long getCompletedTaskCount() {
        ThreadPoolExecutor executor = (ThreadPoolExecutor)this.getMonitored();
        if (executor == null) {
            return -1L;
        }
        return executor.getCompletedTaskCount();
    }

    @Override
    public int getActiveCount() {
        ThreadPoolExecutor executor = (ThreadPoolExecutor)this.getMonitored();
        if (executor == null) {
            return -1;
        }
        return executor.getActiveCount();
    }

    @Override
    public int getQueuedTasks() {
        ThreadPoolExecutor executor = (ThreadPoolExecutor)this.getMonitored();
        if (executor == null) {
            return -1;
        }
        return executor.getQueue().size();
    }
}

